/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.diff;

import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.aom.utils.CodeRedefinitionStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeIdLCS {
    private List<String> lcs;
    private Map<String, String> nodeIdReplacements = new HashMap<String, String>();

    public NodeIdLCS(List<String> parent, List<String> child, int childSpecializationDepth) {
        this.calculateReplacements(parent, child, childSpecializationDepth);
        this.lcs = this.longestCommonSubsequence(parent, child);
    }

    public List<String> longestCommonSubsequence(List<String> parent, List<String> child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        ArrayList<String> longestCommonSubString = new ArrayList<String>(Math.max(parent.size(), child.size()));
        int[][] lcsLengthArray = this.longestCommonSubstringLengthArray(parent, child);
        int i = parent.size() - 1;
        int j = child.size() - 1;
        int k = lcsLengthArray[parent.size()][child.size()] - 1;
        while (k >= 0) {
            if (this.equals(parent.get(i), child.get(j))) {
                longestCommonSubString.add(parent.get(i));
                --i;
                --j;
                --k;
                continue;
            }
            if (lcsLengthArray[i + 1][j] < lcsLengthArray[i][j + 1]) {
                --i;
                continue;
            }
            --j;
        }
        Collections.reverse(longestCommonSubString);
        return longestCommonSubString;
    }

    private void calculateReplacements(List<String> parent, List<String> child, int childSpecializationDepth) {
        for (String nodeId : child) {
            String parentNodeId;
            if (AOMUtils.getSpecialisationStatusFromCode((String)nodeId, (int)childSpecializationDepth) != CodeRedefinitionStatus.REDEFINED || child.contains(parentNodeId = AOMUtils.getCodeInNearestParent((String)nodeId))) continue;
            this.nodeIdReplacements.put(nodeId, parentNodeId);
        }
    }

    public int[][] longestCommonSubstringLengthArray(List<String> parent, List<String> child) {
        int[][] lcsLengthArray = new int[parent.size() + 1][child.size() + 1];
        for (int i = 0; i < parent.size(); ++i) {
            for (int j = 0; j < child.size(); ++j) {
                if (i == 0) {
                    lcsLengthArray[i][j] = 0;
                }
                if (j == 0) {
                    lcsLengthArray[i][j] = 0;
                }
                lcsLengthArray[i + 1][j + 1] = this.equals(parent.get(i), child.get(j)) ? lcsLengthArray[i][j] + 1 : Math.max(lcsLengthArray[i + 1][j], lcsLengthArray[i][j + 1]);
            }
        }
        return lcsLengthArray;
    }

    public boolean equals(String parent, String child) {
        String replacedChild = this.nodeIdReplacements.get(child);
        if (replacedChild == null) {
            replacedChild = child;
        }
        return parent.equals(replacedChild);
    }

    public boolean contains(String childNodeId) {
        String replacedChild = this.nodeIdReplacements.get(childNodeId);
        if (replacedChild == null) {
            replacedChild = childNodeId;
        }
        return this.lcs.contains(replacedChild);
    }

    public List<String> getLCS() {
        return this.lcs;
    }

    public boolean isLast(String nodeId) {
        return this.equals(this.lcs.get(this.lcs.size() - 1), nodeId);
    }
}

