/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.diff;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DifferentialPathGenerator {
    private Archetype diffed;

    public void replace(Archetype diffed) {
        this.diffed = diffed;
        for (CAttribute attribute : diffed.getDefinition().getAttributes()) {
            this.replace(attribute, null);
        }
    }

    private void replace(CAttribute attribute, @Nullable CompressablePath compressablePath) {
        if (this.canAddToCompressablePath(attribute)) {
            if (compressablePath == null) {
                compressablePath = new CompressablePath(attribute);
                CObject cObject = (CObject)attribute.getChildren().get(0);
                if (this.canAddToCompressablePath(cObject)) {
                    this.replaceChildAttribute(cObject, compressablePath);
                } else {
                    this.replaceChildAttributes(cObject);
                }
            } else {
                compressablePath.addAttribute(attribute);
                CObject cObject = (CObject)attribute.getChildren().get(0);
                if (this.canAddToCompressablePath(cObject)) {
                    this.replaceChildAttribute(cObject, compressablePath);
                } else {
                    compressablePath.replaceWithSingleAttribute();
                    this.replaceChildAttributes(cObject);
                }
            }
        } else {
            if (compressablePath != null) {
                compressablePath.addAttribute(attribute);
                compressablePath.replaceWithSingleAttribute();
            }
            for (CObject cObject : attribute.getChildren()) {
                this.replaceChildAttributes(cObject);
            }
        }
    }

    private void replaceChildAttribute(CObject cObject, CompressablePath compressablePath) {
        CAttribute childAttribute = (CAttribute)cObject.getAttributes().get(0);
        this.replace(childAttribute, compressablePath);
    }

    private void replaceChildAttributes(CObject cObject) {
        for (CAttribute childAttribute : cObject.getAttributes()) {
            this.replace(childAttribute, null);
        }
    }

    private boolean canAddToCompressablePath(CAttribute attribute) {
        return attribute.getCardinality() == null && attribute.getExistence() == null && attribute.getChildren().size() == 1;
    }

    private boolean canAddToCompressablePath(CObject cObject) {
        if (cObject instanceof CComplexObject) {
            return cObject.specialisationDepth() < this.diffed.specializationDepth() && cObject.getAttributes().size() == 1 && cObject.getOccurrences() == null && cObject.getSiblingOrder() == null && ((CComplexObject)cObject).getAttributeTuples().isEmpty();
        }
        return false;
    }

    class CompressablePath {
        private List<CAttribute> attributes = new ArrayList<CAttribute>();

        public CompressablePath(CAttribute rootAtttribute) {
            this.attributes.add(rootAtttribute);
        }

        public void addAttribute(CAttribute attribute) {
            this.attributes.add(attribute);
        }

        public CAttribute getRootAttribute() {
            return this.attributes.get(0);
        }

        public CAttribute getLastAttribute() {
            return this.attributes.get(this.attributes.size() - 1);
        }

        public List<CAttribute> getAttributes() {
            return this.attributes;
        }

        public void replaceWithSingleAttribute() {
            CAttribute root = this.getRootAttribute();
            CAttribute last = this.getLastAttribute();
            root.setChildren(last.getChildren());
            root.setDifferentialPath(this.getPath());
            root.setRmAttributeName(last.getRmAttributeName());
            root.setExistence(last.getExistence());
            root.setCardinality(last.getCardinality());
        }

        public String getPath() {
            CAttribute last = this.getLastAttribute();
            CAttribute root = this.getRootAttribute();
            CObject cObject = null;
            CAttribute currentAttribute = last;
            StringBuilder pathBuilder = new StringBuilder();
            while (currentAttribute != root) {
                this.addToPath(currentAttribute, cObject, pathBuilder);
                cObject = currentAttribute.getParent();
                currentAttribute = cObject.getParent();
            }
            this.addToPath(root, cObject, pathBuilder);
            return pathBuilder.toString();
        }

        private void addToPath(CAttribute currentAttribute, CObject cObject, StringBuilder pathBuilder) {
            if (cObject != null) {
                pathBuilder.insert(0, "]");
                pathBuilder.insert(0, cObject.getNodeId());
                pathBuilder.insert(0, "[");
            }
            pathBuilder.insert(0, currentAttribute.getRmAttributeName());
            pathBuilder.insert(0, "/");
        }
    }
}

