/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.validations.SpecializedDefinitionValidation;
import java.util.List;
import org.openehr.utils.message.I18n;

public class SpecializedAttributeValidation {
    public boolean validateTest(CAttribute attribute, SpecializedDefinitionValidation validation) {
        if (!attribute.isSecondOrderConstrained()) {
            return !AOMUtils.isPhantomPathAtLevel((List)attribute.getPathSegments(), (int)validation.getFlatParent().specializationDepth()) && validation.getFlatParent().hasPath(AOMUtils.pathAtSpecializationLevel((List)attribute.getPathSegments(), (int)validation.getFlatParent().specializationDepth()));
        }
        return false;
    }

    public void validate(CAttribute attribute, SpecializedDefinitionValidation validation) {
        Archetype flatParent = validation.getFlatParent();
        CAttribute parentAttribute = (CAttribute)flatParent.itemAtPath(AOMUtils.pathAtSpecializationLevel((List)attribute.getPathSegments(), (int)flatParent.specializationDepth()));
        if (!attribute.cConformsTo(parentAttribute).booleanValue()) {
            if (attribute.getDifferentialPath() == null && attribute.isMultiple() != parentAttribute.isMultiple()) {
                validation.addMessageWithPath(ErrorType.VSAM, attribute.path());
            } else if (!attribute.existenceConformsTo(parentAttribute).booleanValue()) {
                validation.addMessageWithPath(ErrorType.VSANCE, attribute.path(), I18n.t((String)"Attribute existence is {0}, which does not conform to parent existince {1}", (Object[])new Object[]{attribute.getExistence(), parentAttribute.getExistence()}));
            } else if (!attribute.cardinalityConformsTo(parentAttribute).booleanValue()) {
                validation.addMessageWithPath(ErrorType.VSANCC, attribute.path(), I18n.t((String)"Attribute cardinality {0} does not conform to parent cardinality {1}", (Object[])new Object[]{attribute.getCardinality(), parentAttribute.getCardinality()}));
            }
        }
    }
}

