/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.MultiplicityInterval;
import org.openehr.utils.message.I18n;

public class MultiplicitiesValidation
extends ValidatingVisitor {
    @Override
    public void validate(CAttribute attribute) {
        this.validateExistence(attribute);
    }

    @Override
    public void validate(CObject cObject) {
        CAttribute attribute;
        if (cObject.getParent() != null && (attribute = cObject.getParent()).getDifferentialPath() == null) {
            if (attribute.isSingle()) {
                if (cObject.getOccurrences() != null && (cObject.getOccurrences().isUpperUnbounded() || (Integer)cObject.getOccurrences().getUpper() > 1)) {
                    this.addMessageWithPath(ErrorType.VACSO, cObject.path(), I18n.t((String)"The attribute {0} of type {1} can only have a single value, but the occurrences of the C_OBJECTS below has an upper limit of more than 1", (Object[])new Object[]{attribute.getRmAttributeName(), attribute.getParent().getRmTypeName()}));
                }
            } else {
                Cardinality cardinality = attribute.getCardinality();
                if (cardinality != null && cardinality.getInterval() == null) {
                    this.addMessageWithPath(ErrorType.OTHER, attribute.path(), I18n.t((String)"A cardinality must have an interval - in this case it is null", (Object[])new Object[0]));
                } else if (cardinality != null && !cardinality.getInterval().isUpperUnbounded() && cObject.getOccurrences() != null && !cObject.getOccurrences().isUpperUnbounded() && (Integer)cObject.getOccurrences().getUpper() > (Integer)cardinality.getInterval().getUpper()) {
                    this.addMessageWithPath(ErrorType.VACMCU, cObject.path(), I18n.t((String)"The occurrences upper limit of the C_OBJECT {0} was {1}, which is greater than the parent attribute cardinality {2}", (Object[])new Object[]{cObject.getNodeId(), cObject.getOccurrences().getUpper(), cardinality.getInterval().getUpper()}));
                }
            }
        }
    }

    private void validateExistence(CAttribute attribute) {
        MultiplicityInterval existence = attribute.getExistence();
        if (existence != null) {
            if (existence.getLower() == null || existence.getUpper() == null || existence.isUpperUnbounded() || existence.isLowerUnbounded() || !existence.isLowerIncluded() || !existence.isUpperIncluded()) {
                this.addMessageWithPath(ErrorType.SEXLMG, attribute.path(), I18n.t((String)"Syntax error: existence must be one of 0..0, 0..1, or 1..1, but was {0}", (Object[])new Object[]{existence}));
            } else if ((Integer)existence.getLower() == 0) {
                if ((Integer)existence.getUpper() != 0 && (Integer)existence.getUpper() != 1) {
                    this.addMessageWithPath(ErrorType.SEXLU, attribute.path(), I18n.t((String)"Syntax error: existence must be one of 0..0, 0..1, or 1..1, but was {0}", (Object[])new Object[]{existence}));
                }
            } else if ((Integer)existence.getLower() == 1) {
                if ((Integer)existence.getUpper() != 1) {
                    this.addMessageWithPath(ErrorType.SEXLU, attribute.path(), I18n.t((String)"Syntax error: existence must be one of 0..0, 0..1, or 1..1, but was {0}", (Object[])new Object[]{existence}));
                }
            } else if ((Integer)existence.getLower() > 1 || (Integer)existence.getLower() < 0) {
                this.addMessageWithPath(ErrorType.SEXLU, attribute.path(), I18n.t((String)"Syntax error: existence must be one of 0..0, 0..1, or 1..1, but was {0}", (Object[])new Object[]{existence}));
            }
        }
    }
}

