/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.primitives.COrdered;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import com.nedap.archie.base.Interval;
import org.openehr.utils.message.I18n;

public class BasicDefinitionObjectValidation
extends ValidatingVisitor {
    @Override
    protected void validate(CObject cObject) {
        if (cObject.getOccurrences() != null) {
            this.validateOccurrences(cObject);
        }
        if (cObject instanceof COrdered) {
            this.validateCOrdered((COrdered)cObject);
        }
    }

    private void validateCOrdered(COrdered<?> cOrdered) {
        for (Interval interval : cOrdered.getConstraint()) {
            if (this.isValidInterval((Interval<? extends Comparable>)interval)) continue;
            this.addMessageWithPath(ErrorType.OTHER, cOrdered.path(), I18n.t((String)"The constraint interval for this {0} has lower > upper, this is not allowed", (Object[])new Object[]{cOrdered.getClass().getSimpleName()}));
        }
    }

    @Override
    protected void validate(CAttribute cAttribute) {
        if (cAttribute.getCardinality() != null) {
            if (cAttribute.getCardinality().getInterval() == null) {
                this.addMessageWithPath(ErrorType.OTHER, cAttribute.path(), I18n.t((String)"Cardinality must have an interval present, but it was null", (Object[])new Object[0]));
            } else if (!this.isValidInterval((Interval<? extends Comparable>)cAttribute.getCardinality().getInterval())) {
                this.addMessageWithPath(ErrorType.OTHER, cAttribute.path(), I18n.t((String)"The attribute cardinality interval has lower > upper, this is not allowed", (Object[])new Object[0]));
            }
        }
    }

    private void validateOccurrences(CObject cObject) {
        if (!this.isValidInterval((Interval<? extends Comparable>)cObject.getOccurrences())) {
            this.addMessageWithPath(ErrorType.OTHER, cObject.path(), I18n.t((String)"The occurrences interval has lower > upper, this is not allowed", (Object[])new Object[0]));
        }
    }

    private boolean isValidInterval(Interval<? extends Comparable> interval) {
        return interval.getUpper() == null || interval.getLower() == null || interval.isLowerUnbounded() || interval.isUpperUnbounded() || interval.getComparableUpper().compareTo(interval.getComparableLower()) >= 0;
    }
}

