/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import java.util.List;
import org.openehr.utils.message.I18n;

public class AttributeTupleValidation
extends ValidatingVisitor {
    @Override
    protected void validate(CComplexObject cObject) {
        if (cObject.getAttributeTuples() != null) {
            for (CAttributeTuple tuple : cObject.getAttributeTuples()) {
                List members = tuple.getMembers();
                if (members == null) {
                    this.addMessageWithPath(ErrorType.OTHER, cObject.getPath(), "An attribute tuple must have members");
                    continue;
                }
                for (CAttribute cAttribute : tuple.getMembers()) {
                    if (this.combinedModels.attributeExists(cObject.getRmTypeName(), cAttribute.getRmAttributeName())) continue;
                    this.addMessageWithPath(ErrorType.VCARM, cObject.getPath(), I18n.t((String)"Tuple member attribute {0} is not an attribute of type {1}", (Object[])new Object[]{cAttribute.getRmAttributeName(), cObject.getRmTypeName()}));
                }
                for (CPrimitiveTuple primitiveTuple : tuple.getTuples()) {
                    if (primitiveTuple.getMembers().size() == members.size()) continue;
                    this.addMessageWithPath(ErrorType.OTHER, cObject.getPath(), I18n.t((String)"In the attribute tuple {0} members were specified, but the primitive tuple has {1} members instead", (Object[])new Object[]{members.size(), primitiveTuple.getMembers().size()}));
                }
            }
        }
    }
}

