/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator;

import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.archetypevalidator.ArchetypeValidationBase;
import java.util.ArrayDeque;

public abstract class ValidatingVisitor
extends ArchetypeValidationBase {
    @Override
    public void validate() {
        this.beginValidation();
        ArrayDeque<CComplexObject> workList = new ArrayDeque<CComplexObject>();
        workList.add(this.archetype.getDefinition());
        while (!workList.isEmpty()) {
            CObject cObject = (CObject)workList.pop();
            this.validate(cObject);
            for (CAttribute attribute : cObject.getAttributes()) {
                this.validate(attribute);
                workList.addAll(attribute.getChildren());
            }
        }
        this.endValidation();
    }

    protected void beginValidation() {
    }

    protected void endValidation() {
    }

    protected void validate(CObject cObject) {
        if (cObject instanceof CComplexObject) {
            this.validate((CComplexObject)cObject);
        } else if (cObject instanceof CPrimitiveObject) {
            this.validate((CPrimitiveObject)cObject);
        } else if (cObject instanceof ArchetypeSlot) {
            this.validate((ArchetypeSlot)cObject);
        } else if (cObject instanceof CComplexObjectProxy) {
            this.validate((CComplexObjectProxy)cObject);
        }
    }

    protected void validate(ArchetypeSlot cObject) {
    }

    protected void validate(CComplexObjectProxy cObject) {
    }

    protected void validate(CComplexObject cObject) {
    }

    protected void validate(CPrimitiveObject cObject) {
    }

    protected void validate(CAttribute cAttribute) {
    }
}

