/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.validators;

import org.openehr.bmm.persistence.validation.BmmMessageIds;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.utils.message.MessageCode;
import org.openehr.utils.message.MessageDescriptor;
import org.openehr.utils.message.MessageLogger;
import org.openehr.utils.message.MessageSeverity;

public abstract class ValidatorBase {
    protected MessageLogger logger;

    public ValidatorBase(MessageLogger logger) {
        this.logger = logger;
    }

    public ValidatorBase() {
    }

    public void setLogger(MessageLogger logger) {
        this.logger = logger;
    }

    protected void addValidityError(PBmmSchema schema, String sourceSchemaId, MessageCode aKey, Object ... arguments) {
        if (sourceSchemaId.equals(schema.getSchemaId())) {
            this.logger.addError(aKey, arguments);
        } else {
            MessageDescriptor messageDescriptor = new MessageDescriptor(aKey, MessageSeverity.ERROR, aKey.getMessage(arguments), null);
            this.logger.addError((MessageCode)BmmMessageIds.ec_BMM_INCERR2, new Object[]{schema.getSchemaId(), sourceSchemaId, messageDescriptor.getMessage()});
        }
    }
}

