/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.Map;
import org.openehr.bmm.v2.persistence.CaseInsensitiveLinkedHashMap;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmPackageContainer;
import org.openehr.bmm.v2.persistence.PBmmSchema;

public class PreprocessPersistedSchema {
    public void preprocess(PBmmSchema schema) {
        Map<String, PBmmClass> classDefinitions = schema.getClassDefinitions();
        CaseInsensitiveLinkedHashMap<PBmmClass> newClassDefinitions = new CaseInsensitiveLinkedHashMap<PBmmClass>();
        newClassDefinitions.putAll(classDefinitions);
        schema.setClassDefinitions(newClassDefinitions);
        for (PBmmClass clazz : classDefinitions.values()) {
            clazz.setSourceSchemaId(schema.getSchemaId());
        }
        Map<String, PBmmClass> primitiveTypes = schema.getPrimitiveTypes();
        CaseInsensitiveLinkedHashMap<PBmmClass> newPrimitiveTypes = new CaseInsensitiveLinkedHashMap<PBmmClass>();
        newPrimitiveTypes.putAll(primitiveTypes);
        schema.setPrimitiveTypes(newPrimitiveTypes);
        for (PBmmClass clazz : primitiveTypes.values()) {
            clazz.setSourceSchemaId(schema.getSchemaId());
        }
        this.convertPackages(schema);
    }

    private void convertPackages(PBmmPackageContainer schema) {
        Map<String, PBmmPackage> packages = schema.getPackages();
        CaseInsensitiveLinkedHashMap<PBmmPackage> newpackages = new CaseInsensitiveLinkedHashMap<PBmmPackage>();
        newpackages.putAll(packages);
        for (PBmmPackage bmmPackage : newpackages.values()) {
            this.convertPackages(bmmPackage);
        }
        schema.setPackages(newpackages);
    }
}

