/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openehr.bmm.persistence.validation.BmmMessageIds;
import org.openehr.bmm.v2.persistence.BmmIncludeSpec;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmSchemaConverter;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.utils.message.MessageCode;
import org.openehr.utils.message.MessageLogger;

public class IncludesProcessor {
    public List<String> getIncludeIds(PBmmSchema schema) {
        return schema.getIncludes().values().stream().map(includeSpec -> includeSpec.getId()).collect(Collectors.toCollection(ArrayList::new));
    }

    public void cloneSchemaAndAddIncludes(BmmValidationResult validationResult, BmmRepository repository, MessageLogger logger) {
        PBmmSchema schema = validationResult.getOriginalSchema();
        for (BmmIncludeSpec include : schema.getIncludes().values()) {
            if (repository.containsPersistentSchema(include.getId())) continue;
            logger.addError((MessageCode)BmmMessageIds.ec_bmm_schema_included_schema_not_found, new Object[]{include.getId()});
        }
        if (!logger.hasErrors()) {
            PBmmSchema clone = (PBmmSchema)schema.clone();
            validationResult.setSchemaWithMergedIncludes(clone);
            for (BmmIncludeSpec include : schema.getIncludes().values()) {
                if (validationResult.getMergedSchemas().contains(include.getId()) && !validationResult.getFailedMergedSchemas().contains(include.getId())) continue;
                BmmValidationResult included = repository.getModel(include.getId());
                if (included == null) {
                    PBmmSchema persistentSchema = repository.getPersistentSchema(include.getId());
                    BmmSchemaConverter bmmSchemaConverter = new BmmSchemaConverter(repository);
                    included = bmmSchemaConverter.validateConvertAndAddToRepo(persistentSchema);
                }
                if (!included.passes()) {
                    logger.addError((MessageCode)BmmMessageIds.ec_bmm_schema_includes_valiidation_failed, new Object[]{schema.getSchemaId(), included.getLogger().toString()});
                    validationResult.addFailedMerge(include.getId());
                    continue;
                }
                this.mergeIncluded(validationResult, included);
            }
        }
    }

    private void mergeIncluded(BmmValidationResult includingValidationResult, BmmValidationResult includedValidation) {
        PBmmSchema including = includingValidationResult.getSchemaWithMergedIncludes();
        PBmmSchema included = includedValidation.getSchemaWithMergedIncludes();
        if (included.getArchetypeParentClass() != null && including.getArchetypeParentClass() == null) {
            including.setArchetypeParentClass(included.getArchetypeParentClass());
        }
        if (included.getArchetypeDataValueParentClass() != null && including.getArchetypeDataValueParentClass() == null) {
            including.setArchetypeDataValueParentClass(included.getArchetypeDataValueParentClass());
        }
        LinkedHashSet<String> newClosurePackages = new LinkedHashSet<String>();
        newClosurePackages.addAll(included.getArchetypeRmClosurePackages());
        newClosurePackages.addAll(including.getArchetypeRmClosurePackages());
        included.setArchetypeRmClosurePackages(new ArrayList<String>(newClosurePackages));
        for (Map.Entry<String, PBmmPackage> packageEntry : includedValidation.getCanonicalPackages().entrySet()) {
            if (includingValidationResult.getCanonicalPackages().containsKey(packageEntry.getKey())) {
                PBmmPackage persistedBmmPackage = includingValidationResult.getCanonicalPackages().get(packageEntry.getKey());
                this.merge(persistedBmmPackage, packageEntry.getValue());
                continue;
            }
            includingValidationResult.getCanonicalPackages().put(packageEntry.getKey(), (PBmmPackage)packageEntry.getValue().clone());
        }
        for (String className : included.getClassDefinitions().keySet()) {
            PBmmClass bmmClass = included.getClassDefinitions().get(className);
            including.getClassDefinitions().put(className, (PBmmClass)bmmClass.clone());
        }
        for (String primitiveTypeName : included.getPrimitiveTypes().keySet()) {
            PBmmClass pBmmClass = included.getPrimitiveTypes().get(primitiveTypeName);
            including.getPrimitiveTypes().put(primitiveTypeName, (PBmmClass)pBmmClass.clone());
        }
        includingValidationResult.addMergedSchema(included.getSchemaId().toUpperCase());
    }

    private void merge(PBmmPackage including, PBmmPackage included) {
        LinkedHashSet<String> newClasses = new LinkedHashSet<String>(including.getClasses());
        newClasses.addAll(included.getClasses());
        including.setClasses(new ArrayList<String>(newClasses));
        included.getPackages().values().forEach(p -> {
            PBmmPackage sourcePackage = including.getPackages().get(p.getName());
            if (sourcePackage != null) {
                this.merge(sourcePackage, (PBmmPackage)((Object)p));
            } else {
                including.getPackages().put(p.getName().toUpperCase(), (PBmmPackage)p.clone());
            }
        });
    }
}

