/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmSimpleClass;
import org.openehr.bmm.core.BmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmSchema;

public class BmmClassProcessor {
    private final BmmModel model;
    private final BiFunction<PBmmClass, BmmClassProcessor, BmmClass> populateBmmClass;
    private final Map<String, PBmmClass> pBmmClassMap;
    private final Set<String> unprocessedClasses;
    private final Stack<String> processingStack;

    public BmmClassProcessor(BmmModel model, PBmmSchema pBmmSchema, BiFunction<PBmmClass, BmmClassProcessor, BmmClass> populateBmmClass) {
        this.model = model;
        this.unprocessedClasses = new LinkedHashSet<String>();
        this.pBmmClassMap = new LinkedHashMap<String, PBmmClass>();
        this.processingStack = new Stack();
        pBmmSchema.getPrimitiveTypes().forEach((name, clazz) -> {
            this.pBmmClassMap.put(name.toUpperCase(), (PBmmClass)((Object)clazz));
            this.unprocessedClasses.add(name.toUpperCase());
        });
        pBmmSchema.getClassDefinitions().forEach((name, clazz) -> {
            this.pBmmClassMap.put(name.toUpperCase(), (PBmmClass)((Object)clazz));
            this.unprocessedClasses.add(name.toUpperCase());
        });
        this.populateBmmClass = populateBmmClass;
    }

    public void run() {
        for (String className : new ArrayList<String>(this.unprocessedClasses)) {
            this.processBmmClassIfNeeded(className);
        }
    }

    public BmmClass getClassDefinition(String typeName) {
        this.processBmmClassIfNeeded(typeName);
        return this.model.getClassDefinition(typeName);
    }

    private void processBmmClassIfNeeded(String typeName) {
        if (this.unprocessedClasses.contains(typeName.toUpperCase()) && !this.processingStack.contains(typeName.toUpperCase())) {
            try {
                this.processingStack.push(typeName.toUpperCase());
                BmmClass apply = this.populateBmmClass.apply(this.pBmmClassMap.get(typeName.toUpperCase()), this);
                this.unprocessedClasses.remove(typeName.toUpperCase());
            }
            finally {
                this.processingStack.pop();
            }
        }
    }

    public BmmSimpleType getAnyTypeDefinition() {
        BmmSimpleClass anyClassDefinition = this.model.getAnyClassDefinition();
        this.processBmmClassIfNeeded(anyClassDefinition.getName());
        return this.model.getAnyTypeDefinition();
    }

    public BmmClass getUnprocessedClassDefinition(String name) {
        return this.model.getClassDefinition(name);
    }
}

