/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmGenericClass;
import org.openehr.bmm.core.BmmGenericType;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.core.BmmUnitaryType;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.PBmmOpenType;
import org.openehr.bmm.v2.persistence.PBmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmType;
import org.openehr.bmm.v2.persistence.PBmmUnitaryType;
import org.openehr.bmm.v2.validation.converters.BmmClassProcessor;

public final class PBmmGenericType
extends PBmmUnitaryType {
    private String rootType;
    private Map<String, PBmmType> genericParameterDefs;
    private List<String> genericParameters;

    public PBmmGenericType() {
    }

    public PBmmGenericType(String aTypeName, List<String> genericParams) {
        this.rootType = aTypeName;
        this.genericParameters = genericParams;
    }

    public String getRootType() {
        return this.rootType;
    }

    @Override
    public String baseType() {
        return this.rootType;
    }

    public Map<String, PBmmType> getGenericParameterDefs() {
        if (this.genericParameterDefs == null) {
            this.genericParameterDefs = new LinkedHashMap<String, PBmmType>();
        }
        return this.genericParameterDefs;
    }

    public void setGenericParameterDefs(Map<String, PBmmType> genericParameterDefs) {
        this.genericParameterDefs = genericParameterDefs;
    }

    public List<String> getGenericParameters() {
        if (this.genericParameters == null) {
            this.genericParameters = new ArrayList<String>();
        }
        return this.genericParameters;
    }

    public void setGenericParameters(List<String> genericParameters) {
        this.genericParameters = genericParameters;
    }

    @JsonIgnore
    public List<PBmmType> getGenericParameterRefs() {
        ArrayList<PBmmType> genericParameterReferences = new ArrayList<PBmmType>();
        if (this.genericParameterDefs != null && this.genericParameterDefs.size() > 0) {
            genericParameterReferences.addAll(this.genericParameterDefs.values());
        } else {
            this.genericParameters.forEach(param -> {
                if (BmmDefinitions.isFormalGenericParameterName(param)) {
                    PBmmOpenType openType = new PBmmOpenType((String)param);
                    genericParameterReferences.add(openType);
                } else {
                    PBmmSimpleType simpleType = new PBmmSimpleType((String)param);
                    genericParameterReferences.add(simpleType);
                }
            });
        }
        return genericParameterReferences;
    }

    @Override
    public BmmGenericType createBmmType(BmmClassProcessor processor, BmmClass classDefinition) {
        BmmClass rootClassDef = processor.getClassDefinition(this.rootType);
        if (rootClassDef instanceof BmmGenericClass) {
            BmmGenericType bmmType = new BmmGenericType((BmmGenericClass)rootClassDef);
            for (PBmmType param : this.getGenericParameterRefs()) {
                BmmType paramBmmType = param.createBmmType(processor, classDefinition);
                if (paramBmmType instanceof BmmUnitaryType) {
                    bmmType.addGenericParameter(paramBmmType);
                    continue;
                }
                throw new RuntimeException("BmmClass " + this.getRootType() + " generic parameter" + param.asTypeString() + " not BmmUnitaryType");
            }
            return bmmType;
        }
        throw new RuntimeException("BmmClass " + this.getRootType() + " is not defined in this model or not a generic type");
    }

    @Override
    public String asTypeString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rootType).append(BmmDefinitions.GENERIC_LEFT_DELIMITER);
        List<PBmmType> parameterReferences = this.getGenericParameterRefs();
        for (int i = 0; i < parameterReferences.size(); ++i) {
            builder.append(parameterReferences.get(i).asTypeString());
            if (i >= parameterReferences.size() - 1) continue;
            builder.append(BmmDefinitions.GENERIC_SEPARATOR);
        }
        builder.append(BmmDefinitions.GENERIC_RIGHT_DELIMITER);
        return builder.toString();
    }

    @Override
    public List<String> flattenedTypeList() {
        ArrayList<String> retVal = new ArrayList<String>();
        this.getGenericParameterRefs().forEach(item -> retVal.addAll(item.flattenedTypeList()));
        return retVal;
    }
}

