/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmContainerType;
import org.openehr.bmm.core.BmmGenericClass;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.core.BmmUnitaryType;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.PBmmOpenType;
import org.openehr.bmm.v2.persistence.PBmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmType;
import org.openehr.bmm.v2.persistence.PBmmUnitaryType;
import org.openehr.bmm.v2.validation.converters.BmmClassProcessor;

public class PBmmContainerType
extends PBmmType {
    private String containerType;
    private PBmmUnitaryType typeDef;
    private String type;

    public String getContainerType() {
        return this.containerType;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public PBmmUnitaryType getTypeDef() {
        return this.typeDef;
    }

    public void setTypeDef(PBmmUnitaryType typeDef) {
        this.typeDef = typeDef;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String baseType() {
        if (this.type != null) {
            return this.type;
        }
        return this.typeDef.baseType();
    }

    @Override
    public String asTypeString() {
        return this.containerType + BmmDefinitions.GENERIC_LEFT_DELIMITER + this.getTypeRef().asTypeString() + BmmDefinitions.GENERIC_RIGHT_DELIMITER;
    }

    @Override
    public List<String> flattenedTypeList() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add(this.containerType);
        if (this.getTypeRef() != null) {
            retVal.addAll(this.getTypeRef().flattenedTypeList());
        }
        return retVal;
    }

    @JsonIgnore
    public PBmmUnitaryType getTypeRef() {
        if (this.typeDef != null) {
            return this.typeDef;
        }
        if (this.type != null) {
            if (BmmDefinitions.isFormalGenericParameterName(this.type)) {
                return new PBmmOpenType(this.type);
            }
            return new PBmmSimpleType(this.type);
        }
        return null;
    }

    @Override
    public BmmContainerType createBmmType(BmmClassProcessor processor, BmmClass classDefinition) {
        BmmType containedBmmType;
        BmmClass containerClassDef = processor.getClassDefinition(this.containerType);
        PBmmUnitaryType containedType = this.getTypeRef();
        if (containerClassDef instanceof BmmGenericClass && containedType != null && (containedBmmType = containedType.createBmmType(processor, classDefinition)) instanceof BmmUnitaryType) {
            return new BmmContainerType((BmmUnitaryType)containedBmmType, (BmmGenericClass)containerClassDef);
        }
        throw new RuntimeException("BmmClass " + containerClassDef.getName() + " is not defined in this model or not a generic type");
    }
}

