/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import com.nedap.archie.base.MultiplicityInterval;
import java.io.Serializable;
import org.openehr.bmm.core.BmmModelElement;
import org.openehr.bmm.core.BmmType;

public class BmmProperty<T extends BmmType>
extends BmmModelElement
implements Serializable {
    public static final String P_BMM_GENERIC_PROPERTY = "P_BMM_GENERIC_PROPERTY";
    public static final String P_BMM_CONTAINER_PROPERTY = "P_BMM_CONTAINER_PROPERTY";
    private String name;
    private boolean isMandatory;
    private boolean isComputed;
    private T type;
    private boolean isImRuntime;
    private boolean isImInfrastructure;

    public BmmProperty(String aName, T aType, String aDocumentation, boolean isMandatoryFlag, boolean isComputedFlag) {
        this.name = aName;
        this.type = aType;
        this.setDocumentation(aDocumentation);
        this.isMandatory = isMandatoryFlag;
        this.isComputed = isComputedFlag;
    }

    public BmmProperty(BmmProperty<T> other) {
        this.name = other.name;
        this.type = other.type;
        this.setDocumentation(other.getDocumentation());
        this.isMandatory = other.isMandatory;
        this.isComputed = other.isComputed;
        this.isImInfrastructure = other.isImInfrastructure;
        this.isImRuntime = other.isImRuntime;
    }

    public BmmProperty() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.isMandatory = mandatory;
    }

    public boolean getComputed() {
        return this.isComputed;
    }

    public void setComputed(boolean computed) {
        this.isComputed = computed;
    }

    public T getType() {
        return this.type;
    }

    public void setType(T type) {
        this.type = type;
    }

    public boolean getImRuntime() {
        return this.isImRuntime;
    }

    public void setImRuntime(boolean imRuntime) {
        this.isImRuntime = imRuntime;
    }

    public boolean getImInfrastructure() {
        return this.isImInfrastructure;
    }

    public void setImInfrastructure(boolean imInfrastructure) {
        this.isImInfrastructure = imInfrastructure;
    }

    public static boolean isContainerType(String bmmType) {
        return bmmType.equals("P_BMM_CONTAINER_TYPE") || bmmType.equals("BMM_CONTAINER_TYPE");
    }

    public MultiplicityInterval getExistence() {
        MultiplicityInterval result = this.isMandatory ? MultiplicityInterval.createMandatory() : MultiplicityInterval.createOptional();
        return result;
    }

    public String getDisplayName() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BmmProperty<T> duplicate() {
        return new BmmProperty<T>(this);
    }
}

