/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmPackageContainer;

public class BmmPackage
extends BmmPackageContainer
implements Serializable {
    private String name;
    private Map<String, BmmClass> classes = new LinkedHashMap<String, BmmClass>();
    private String canonicalPath = "";
    private BmmPackage parent;

    public BmmPackage() {
    }

    public BmmPackage(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<BmmClass> getClasses() {
        return new ArrayList<BmmClass>(this.classes.values());
    }

    public void setClasses(Map<String, BmmClass> classes) {
        this.classes = classes;
    }

    public void addClass(String className, BmmClass bmmClass) {
        this.classes.put(className, bmmClass);
    }

    public void addClass(BmmClass bmmClass) {
        this.classes.put(bmmClass.getName(), bmmClass);
    }

    public List<BmmClass> getRootClasses() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getPath() {
        return this.canonicalPath;
    }

    public void setPath(String path) {
        this.canonicalPath = path;
    }

    public void appendToPath(String pathComponent) {
        this.canonicalPath = this.canonicalPath == null || this.canonicalPath.isEmpty() ? pathComponent : this.canonicalPath + "." + pathComponent;
    }

    public boolean hasPackagePath(List<String> packagePathComponents, int currentIndex, int sizeRemaining) {
        boolean matches = false;
        if (sizeRemaining > 1) {
            if (packagePathComponents.get(currentIndex).equalsIgnoreCase(this.name)) {
                BmmPackage bmmPackage;
                Iterator<BmmPackage> iterator = this.getPackages().values().iterator();
                while (iterator.hasNext() && !(matches = (bmmPackage = iterator.next()).hasPackagePath(packagePathComponents, currentIndex + 1, sizeRemaining - 1))) {
                }
            }
        } else if (sizeRemaining == 1) {
            if (packagePathComponents.get(currentIndex).equalsIgnoreCase(this.name)) {
                matches = true;
            }
        } else {
            throw new RuntimeException("Invalid size. Recursion exceeded bounds");
        }
        return matches;
    }

    public BmmPackage getParent() {
        return this.parent;
    }

    public void setParent(BmmPackage parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.name;
    }
}

