/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openehr.bmm.core.BmmDefinedType;
import org.openehr.bmm.core.BmmGenericClass;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class BmmGenericType
extends BmmDefinedType
implements Serializable {
    public List<BmmType> genericParameters = new ArrayList<BmmType>();

    public BmmGenericType(BmmGenericClass baseClass) {
        super(baseClass);
    }

    @Override
    public BmmGenericClass getBaseClass() {
        return (BmmGenericClass)super.getBaseClass();
    }

    public List<BmmType> getGenericParameters() {
        return this.genericParameters;
    }

    public void setGenericParameters(List<BmmType> genericParameters) {
        this.genericParameters = genericParameters;
    }

    public void addGenericParameter(BmmType genericParameter) {
        this.genericParameters.add(genericParameter);
    }

    @Override
    public String getTypeName() {
        return this.getBaseClass().getName() + BmmDefinitions.GENERIC_LEFT_DELIMITER + this.genericParameters.stream().map(t -> t.getTypeName()).collect(Collectors.joining(BmmDefinitions.GENERIC_SEPARATOR.toString())) + BmmDefinitions.GENERIC_RIGHT_DELIMITER;
    }

    @Override
    public String getTypeSignature() {
        return this.getBaseClass().getName() + BmmDefinitions.GENERIC_LEFT_DELIMITER + this.genericParameters.stream().map(t -> t.getTypeSignature()).collect(Collectors.joining(BmmDefinitions.GENERIC_SEPARATOR.toString())) + BmmDefinitions.GENERIC_RIGHT_DELIMITER;
    }

    @Override
    public List<String> getFlattenedTypeList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getBaseClass().getName());
        for (BmmType g : this.genericParameters) {
            result.addAll(g.getFlattenedTypeList());
        }
        return result;
    }

    @Override
    public String toDisplayString() {
        return this.getTypeName();
    }
}

