/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmGenericType;
import org.openehr.bmm.core.BmmParameterType;
import org.openehr.bmm.core.BmmType;

public class BmmGenericClass
extends BmmClass
implements Serializable {
    private Map<String, BmmParameterType> genericParameters;

    public BmmGenericClass(String aName, String aDocumentation, boolean abstractFlag) {
        super(aName, aDocumentation, abstractFlag);
        this.genericParameters = new LinkedHashMap<String, BmmParameterType>();
    }

    public BmmGenericClass() {
    }

    public List<BmmParameterType> getGenericParametersList() {
        return new ArrayList<BmmParameterType>(this.genericParameters.values());
    }

    public Map<String, BmmParameterType> getGenericParameters() {
        return this.genericParameters;
    }

    public Map<String, BmmParameterType> getGenericParameterIndex() {
        return this.genericParameters;
    }

    public void setGenericParameters(Map<String, BmmParameterType> parameters) {
        this.genericParameters = parameters;
    }

    public void addGenericParameter(BmmParameterType genericParameter) {
        this.genericParameters.put(genericParameter.getName().toUpperCase(), genericParameter);
    }

    public BmmParameterType getGenericParameter(String genericParameterName) {
        return this.genericParameters.get(genericParameterName.toUpperCase());
    }

    public BmmParameterType removeGenericParameter(BmmParameterType genericParameter) {
        return this.genericParameters.remove(genericParameter.getName().toUpperCase());
    }

    public BmmParameterType removeGenericParameter(String parameterName) {
        return this.genericParameters.remove(parameterName.toUpperCase());
    }

    @Override
    public BmmGenericType getType() {
        BmmGenericType result = new BmmGenericType(this);
        this.genericParameters.forEach((paramName, param) -> result.addGenericParameter((BmmType)param));
        return result;
    }

    public List<String> getSuppliers() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public BmmGenericClass duplicate() {
        BmmGenericClass target = (BmmGenericClass)super.duplicate();
        target.setGenericParameters(this.getGenericParameters());
        return target;
    }
}

