/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.validators;

import java.util.List;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmContainerProperty;
import org.openehr.bmm.v2.persistence.PBmmContainerType;
import org.openehr.bmm.v2.persistence.PBmmGenericProperty;
import org.openehr.bmm.v2.persistence.PBmmGenericType;
import org.openehr.bmm.v2.persistence.PBmmProperty;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.persistence.PBmmSingleProperty;
import org.openehr.bmm.v2.persistence.PBmmSinglePropertyOpen;

public class ConformanceChecker {
    public boolean propertyConformsTo(PBmmSchema schema, PBmmProperty aChildProperty, PBmmProperty aParentProperty) {
        if (aParentProperty instanceof PBmmSingleProperty && ((PBmmSingleProperty)aParentProperty).getTypeRef().getType().equalsIgnoreCase("Any")) {
            return true;
        }
        if (aChildProperty.getName().equalsIgnoreCase(aParentProperty.getName())) {
            if (aChildProperty instanceof PBmmSingleProperty && aParentProperty instanceof PBmmSingleProperty) {
                PBmmSingleProperty aChildSingleProperty = (PBmmSingleProperty)aChildProperty;
                PBmmSingleProperty aParentSingleProperty = (PBmmSingleProperty)aParentProperty;
                return this.typeStrictlyConformsTo(schema, aChildSingleProperty.getTypeRef().getType(), aParentSingleProperty.getTypeRef().getType());
            }
            if (aParentProperty instanceof PBmmSingleProperty) {
                if (aChildProperty instanceof PBmmSinglePropertyOpen) {
                    return false;
                }
                if (aChildProperty instanceof PBmmSingleProperty) {
                    return true;
                }
            } else {
                if (aChildProperty instanceof PBmmContainerProperty && aParentProperty instanceof PBmmContainerProperty) {
                    PBmmContainerProperty aChildContainerProperty = (PBmmContainerProperty)aChildProperty;
                    PBmmContainerProperty aParentContainerProperty = (PBmmContainerProperty)aParentProperty;
                    return this.typeStrictlyConformsTo(schema, ((PBmmContainerType)((Object)aChildContainerProperty.getTypeRef())).asTypeString(), ((PBmmContainerType)((Object)aParentContainerProperty.getTypeRef())).asTypeString());
                }
                if (aChildProperty instanceof PBmmGenericProperty && aParentProperty instanceof PBmmGenericProperty) {
                    PBmmGenericProperty aChildGenericProperty = (PBmmGenericProperty)aChildProperty;
                    PBmmGenericProperty aParentGenericProperty = (PBmmGenericProperty)aParentProperty;
                    return this.typeStrictlyConformsTo(schema, ((PBmmGenericType)((Object)aChildGenericProperty.getTypeRef())).asTypeString(), ((PBmmGenericType)((Object)aParentGenericProperty.getTypeRef())).asTypeString());
                }
            }
        }
        return false;
    }

    public boolean typeSameAs(String type1, String type2) {
        return BmmDefinitions.typeNameAsFlatList(type1).toString().equalsIgnoreCase(BmmDefinitions.typeNameAsFlatList(type2).toString());
    }

    public boolean typeConformsTo(PBmmSchema schema, String type1, String type2) {
        List<String> typeList1 = null;
        List<String> typeList2 = null;
        typeList1 = BmmDefinitions.typeNameAsFlatList(type1);
        typeList2 = BmmDefinitions.typeNameAsFlatList(type2);
        for (int index = 0; index < typeList1.size() && index < typeList2.size() && schema.hasClassOrPrimitiveDefinition(typeList1.get(index)) && schema.hasClassOrPrimitiveDefinition(typeList2.get(index)); ++index) {
            String typePart1 = typeList1.get(index);
            String typePart2 = typeList2.get(index);
            if (type1.equalsIgnoreCase(typePart2) || this.isAncestor(schema, typePart1, typePart2)) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestor(PBmmSchema schema, String typePart1, String typePart2) {
        PBmmClass classOrPrimitiveDefinition = schema.findClassOrPrimitiveDefinition(typePart1);
        List<String> ancestors = classOrPrimitiveDefinition.getAncestorTypeNames();
        if (ancestors.contains(typePart2)) {
            return true;
        }
        for (String ancestor : ancestors) {
            if (!this.isAncestor(schema, typePart1, ancestor)) continue;
            return true;
        }
        return false;
    }

    public boolean typeStrictlyConformsTo(PBmmSchema schema, String type1, String type2) {
        return this.typeSameAs(type1, type2) || this.typeConformsTo(schema, type1, type2);
    }
}

