/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmGenericParameter;
import org.openehr.bmm.v2.persistence.PBmmSchema;

public class ProcessClassesInOrder {
    public void doAllClassesInOrder(PBmmSchema schema, Consumer<PBmmClass> action, List<PBmmClass> classesToProcess) {
        int attempts = schema.getClassDefinitions().size() * 10;
        int tries = 0;
        ArrayList<String> visitedClasses = new ArrayList<String>();
        LinkedList<PBmmClass> queue = new LinkedList<PBmmClass>();
        for (PBmmClass bmmClass : classesToProcess) {
            this.processClass(schema, action, visitedClasses, queue, bmmClass);
        }
        while (!queue.isEmpty() && tries < attempts) {
            PBmmClass element = (PBmmClass)((Object)queue.remove());
            if (element != null) {
                this.processClass(schema, action, visitedClasses, queue, element);
            }
            ++tries;
        }
    }

    private void processClass(PBmmSchema schema, Consumer<PBmmClass> action, List<String> visitedClasses, Queue<PBmmClass> queue, PBmmClass bmmClass) {
        if (!visitedClasses.contains(bmmClass.getName().toUpperCase())) {
            boolean allAncestorsAndDependenciesVisited = true;
            for (String ancestor : bmmClass.getAncestorTypeNames()) {
                String ancestorClassName = BmmDefinitions.typeNameToClassKey(ancestor);
                if (visitedClasses.contains(ancestorClassName.toUpperCase())) continue;
                allAncestorsAndDependenciesVisited = false;
                PBmmClass ancestorDef = schema.findClassOrPrimitiveDefinition(ancestorClassName);
                queue.add(ancestorDef);
            }
            if (bmmClass.isGeneric()) {
                Map<String, PBmmGenericParameter> parameters = bmmClass.getGenericParameterDefs();
                for (PBmmGenericParameter parameter : parameters.values()) {
                    String conformsTo = parameter.getConformsToType();
                    if (conformsTo == null || visitedClasses.contains(conformsTo.toUpperCase())) continue;
                    allAncestorsAndDependenciesVisited = false;
                    PBmmClass dependency = schema.findClassOrPrimitiveDefinition(conformsTo);
                    queue.add(dependency);
                }
            }
            if (!allAncestorsAndDependenciesVisited) {
                queue.add(bmmClass);
            } else {
                action.accept(bmmClass);
                visitedClasses.add(bmmClass.getName().toUpperCase());
            }
        }
    }
}

