/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import com.nedap.archie.base.Interval;
import com.nedap.archie.base.MultiplicityInterval;
import java.util.ArrayList;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmContainerProperty;
import org.openehr.bmm.core.BmmContainerType;
import org.openehr.bmm.core.BmmGenericProperty;
import org.openehr.bmm.core.BmmGenericType;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.v2.persistence.PBmmContainerProperty;
import org.openehr.bmm.v2.persistence.PBmmGenericProperty;
import org.openehr.bmm.v2.persistence.PBmmGenericType;
import org.openehr.bmm.v2.persistence.PBmmProperty;
import org.openehr.bmm.v2.persistence.PBmmSingleProperty;
import org.openehr.bmm.v2.persistence.PBmmSinglePropertyOpen;
import org.openehr.bmm.v2.persistence.PBmmType;
import org.openehr.bmm.v2.validation.converters.TypeCreator;

public class BmmPropertyCreator {
    public BmmProperty createBmmProperty(PBmmProperty property, BmmModel schema, BmmClass bmmClass) {
        BmmType type = new TypeCreator().createBmmType((PBmmType)((Object)property.getTypeRef()), schema, bmmClass);
        if (property instanceof PBmmSinglePropertyOpen) {
            return this.createSimpleProperty(property, type);
        }
        if (property instanceof PBmmSingleProperty) {
            return this.createSimpleProperty(property, type);
        }
        if (property instanceof PBmmGenericProperty) {
            return this.createGenericProperty(schema, (PBmmGenericProperty)property, (BmmGenericType)type, bmmClass);
        }
        if (property instanceof PBmmContainerProperty) {
            return this.createContainerProperty((PBmmContainerProperty)property, (BmmContainerType)type);
        }
        throw new RuntimeException("unknown property class: " + ((Object)((Object)property)).getClass().getName());
    }

    private BmmContainerProperty createContainerProperty(PBmmContainerProperty property, BmmContainerType type) {
        BmmContainerProperty bmmContainerProperty = new BmmContainerProperty(property.getName(), type);
        this.setBasics(property, bmmContainerProperty);
        if (property.getCardinality() != null) {
            Interval<Integer> cardinality = property.getCardinality();
            bmmContainerProperty.setCardinality(new MultiplicityInterval((Integer)cardinality.getLower(), Boolean.valueOf(cardinality.isLowerIncluded()), Boolean.valueOf(cardinality.isLowerUnbounded()), (Integer)cardinality.getUpper(), Boolean.valueOf(cardinality.isUpperIncluded()), Boolean.valueOf(cardinality.isUpperUnbounded())));
        }
        return bmmContainerProperty;
    }

    private BmmProperty createSimpleProperty(PBmmProperty property, BmmType typeDefinition) {
        BmmProperty<BmmType> bmmProperty = new BmmProperty<BmmType>(property.getName(), typeDefinition);
        this.setBasics(property, bmmProperty);
        return bmmProperty;
    }

    private BmmGenericProperty createGenericProperty(BmmModel schema, PBmmGenericProperty property, BmmGenericType typeDefinition, BmmClass bmmClass) {
        BmmGenericProperty bmmProperty = new BmmGenericProperty(property.getName(), typeDefinition);
        this.setBasics(property, bmmProperty);
        PBmmGenericType pbmmType = (PBmmGenericType)((Object)property.getTypeRef());
        BmmGenericType genericTypeDef = new BmmGenericType();
        genericTypeDef.setBaseClass(schema.getClassDefinition(pbmmType.getRootType()));
        ArrayList<BmmType> genericParams = new ArrayList<BmmType>();
        TypeCreator typeCreator = new TypeCreator();
        for (PBmmType genericParamType : pbmmType.getGenericParamaterRefs()) {
            genericParams.add(typeCreator.createBmmType(genericParamType, schema, bmmClass));
        }
        genericTypeDef.setGenericParameters(genericParams);
        bmmProperty.setGenericTypeDef(genericTypeDef);
        return bmmProperty;
    }

    private void setBasics(PBmmProperty property, BmmProperty bmmProperty) {
        bmmProperty.setDocumentation(property.getDocumentation());
        bmmProperty.setMandatory(property.isMandatory());
        bmmProperty.setComputed(property.isComputed());
        bmmProperty.setImInfrastructure(property.isImInfrastructure());
        bmmProperty.setImRuntime(property.isImRuntime());
        if (bmmProperty.getMandatory() == null) {
            bmmProperty.setMandatory(false);
        }
        if (bmmProperty.getComputed() == null) {
            bmmProperty.setComputed(false);
        }
        if (bmmProperty.getImInfrastructure() == null) {
            bmmProperty.setImInfrastructure(false);
        }
        if (bmmProperty.getImRuntime() == null) {
            bmmProperty.setImRuntime(false);
        }
    }
}

