/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.utils.message.MessageLogger;

public class BmmValidationResult {
    private String schemaId;
    private PBmmSchema originalSchema;
    private MessageLogger logger;
    private BmmModel model;
    private PBmmSchema schemaWithMergedIncludes;
    private Map<String, PBmmPackage> canonicalPackages = new TreeMap<String, PBmmPackage>(String.CASE_INSENSITIVE_ORDER);
    private List<String> mergedSchemas = new ArrayList<String>();
    private List<String> failedMergedSchemas = new ArrayList<String>();

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public MessageLogger getLogger() {
        return this.logger;
    }

    public void setLogger(MessageLogger logger) {
        this.logger = logger;
    }

    public BmmModel getModel() {
        return this.model;
    }

    public void setModel(BmmModel model) {
        this.model = model;
    }

    public boolean passes() {
        return this.logger == null || !this.logger.hasErrors();
    }

    public PBmmSchema getOriginalSchema() {
        return this.originalSchema;
    }

    public void setOriginalSchema(PBmmSchema originalSchema) {
        this.originalSchema = originalSchema;
    }

    public PBmmSchema getSchemaWithMergedIncludes() {
        return this.schemaWithMergedIncludes;
    }

    public void setSchemaWithMergedIncludes(PBmmSchema schemaWithMergedIncludes) {
        this.schemaWithMergedIncludes = schemaWithMergedIncludes;
    }

    public Map<String, PBmmPackage> getCanonicalPackages() {
        return this.canonicalPackages;
    }

    public void setCanonicalPackages(Map<String, PBmmPackage> canonicalPackages) {
        this.canonicalPackages = canonicalPackages;
    }

    public void addMergedSchema(String schemaId) {
        this.mergedSchemas.add(schemaId);
    }

    public List<String> getFailedMergedSchemas() {
        return this.failedMergedSchemas;
    }

    public void setFailedMergedSchemas(List<String> failedMergedSchemas) {
        this.failedMergedSchemas = failedMergedSchemas;
    }

    public void addFailedMerge(String schemaId) {
        this.failedMergedSchemas.add(schemaId);
    }

    public List<String> getMergedSchemas() {
        return this.mergedSchemas;
    }

    public String toString() {
        String result = "Validation result of " + this.schemaId;
        if (this.logger != null) {
            result = result + (this.logger.hasErrors() ? ": Failed" : ": Passed");
        }
        return result;
    }
}

