/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation;

import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmSchemaValidationException;
import org.openehr.bmm.v2.validation.BmmValidation;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.bmm.v2.validation.validators.BasicSchemaValidations;
import org.openehr.bmm.v2.validation.validators.BmmVersionValidation;
import org.openehr.bmm.v2.validation.validators.ClassesValidator;
import org.openehr.bmm.v2.validation.validators.CreatedSchemaValidation;
import org.openehr.bmm.v2.validation.validators.IncludesValidation;
import org.openehr.utils.message.MessageLogger;

public class BmmSchemaValidator {
    private final BmmRepository repository;
    private MessageLogger logger;

    public BmmSchemaValidator(BmmRepository repository) {
        this.repository = repository;
        this.logger = new MessageLogger();
    }

    public void validateSchemaAfterMergeOfIncludes(BmmValidationResult result) {
        this.run(new BasicSchemaValidations(), result, result.getSchemaWithMergedIncludes());
        this.run(new ClassesValidator(), result, result.getSchemaWithMergedIncludes());
    }

    public void validateCreated(BmmValidationResult validationResult, PBmmSchema schema) {
        this.run(new CreatedSchemaValidation(), validationResult, schema);
    }

    public void validateBmmVersion(BmmValidationResult validationResult, PBmmSchema schema) {
        this.run(new BmmVersionValidation(), validationResult, schema);
    }

    public void validateIncludes(BmmValidationResult validationResult, PBmmSchema schema) {
        this.run(new IncludesValidation(), validationResult, schema);
    }

    private void run(BmmValidation validation, BmmValidationResult validationResult, PBmmSchema schema) {
        validation.validate(validationResult, this.repository, this.logger, schema);
    }

    public MessageLogger getLogger() {
        return this.logger;
    }

    public void checkNoExceptions() throws BmmSchemaValidationException {
        if (this.logger.hasErrors()) {
            throw new BmmSchemaValidationException(this.logger);
        }
    }
}

