/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.v2.persistence.PBmmBaseType;
import org.openehr.bmm.v2.persistence.PBmmOpenType;
import org.openehr.bmm.v2.persistence.PBmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmType;

public final class PBmmGenericType
extends PBmmBaseType {
    private String rootType;
    private Map<String, PBmmType> genericParameterDefs;
    private List<String> genericParameters;

    public String getRootType() {
        return this.rootType;
    }

    public void setRootType(String rootType) {
        this.rootType = rootType;
    }

    public Map<String, PBmmType> getGenericParameterDefs() {
        if (this.genericParameterDefs == null) {
            this.genericParameterDefs = new LinkedHashMap<String, PBmmType>();
        }
        return this.genericParameterDefs;
    }

    public void setGenericParameterDefs(Map<String, PBmmType> genericParameterDefs) {
        this.genericParameterDefs = genericParameterDefs;
    }

    public List<String> getGenericParameters() {
        if (this.genericParameters == null) {
            this.genericParameters = new ArrayList<String>();
        }
        return this.genericParameters;
    }

    public void setGenericParameters(List<String> genericParameters) {
        this.genericParameters = genericParameters;
    }

    @JsonIgnore
    public List<PBmmType> getGenericParamaterRefs() {
        ArrayList<PBmmType> genericParameterReferences = new ArrayList<PBmmType>();
        if (this.genericParameterDefs != null && this.genericParameterDefs.size() > 0) {
            genericParameterReferences.addAll(this.genericParameterDefs.values());
        } else {
            this.genericParameters.forEach(param -> {
                if (param.length() == 1) {
                    PBmmOpenType openType = new PBmmOpenType((String)param);
                    genericParameterReferences.add(openType);
                } else {
                    PBmmSimpleType simpleType = new PBmmSimpleType((String)param);
                    genericParameterReferences.add(simpleType);
                }
            });
        }
        return genericParameterReferences;
    }

    @Override
    public String asTypeString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rootType).append("<");
        List<PBmmType> parameterReferences = this.getGenericParamaterRefs();
        for (int i = 0; i < parameterReferences.size(); ++i) {
            builder.append(parameterReferences.get(i).asTypeString());
            if (i >= parameterReferences.size() - 1) continue;
            builder.append(",");
        }
        builder.append(">");
        return builder.toString();
    }

    @Override
    public List<String> flattenedTypeList() {
        ArrayList<String> retVal = new ArrayList<String>();
        this.getGenericParamaterRefs().forEach(item -> retVal.addAll(item.flattenedTypeList()));
        return retVal;
    }
}

