/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.openehr.bmm.core.BmmModelElement;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.core.IBmmPackageContainer;

public abstract class BmmPackageContainer
extends BmmModelElement
implements IBmmPackageContainer,
Serializable {
    public static final String PACKAGE_PATH_DELIMITER = ".";
    private Map<String, BmmPackage> packages = new LinkedHashMap<String, BmmPackage>();

    public void addPackage(BmmPackage bmmPackage) {
        this.packages.put(bmmPackage.getName(), bmmPackage);
    }

    public BmmPackage getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    public Map<String, BmmPackage> getPackages() {
        return this.packages;
    }

    public BmmPackage packageAtPath(String packagePath) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void doRecursivePackages(Consumer<BmmPackage> action) {
        this.packages.forEach((packageName, bmmPackage) -> {
            action.accept((BmmPackage)bmmPackage);
            bmmPackage.doRecursivePackages(action);
        });
    }

    public boolean hasPackagePath(String packagePathString) {
        String[] components = packagePathString.split("\\.");
        ArrayList<String> packagePath = new ArrayList<String>();
        packagePath.addAll(Arrays.asList(components));
        boolean exists = false;
        if (this instanceof BmmPackage) {
            exists = ((BmmPackage)this).hasPackagePath(packagePath, 0, packagePath.size());
        } else {
            BmmPackage bmmPackage;
            Iterator<BmmPackage> iterator = this.packages.values().iterator();
            while (iterator.hasNext() && !(exists = (bmmPackage = iterator.next()).hasPackagePath(packagePath, 0, packagePath.size()))) {
            }
        }
        return exists;
    }

    public boolean hasPackageNameInHierarchy(BmmPackage testPackage) {
        boolean found;
        block3: {
            found = false;
            if (this.packages == null) break block3;
            if (this.packages.containsKey(testPackage.getName())) {
                found = true;
            } else {
                BmmPackage bmmPackage;
                Iterator<BmmPackage> iterator = this.packages.values().iterator();
                while (iterator.hasNext() && !(found = (bmmPackage = iterator.next()).hasPackageNameInHierarchy(testPackage))) {
                }
            }
        }
        return found;
    }
}

