/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.json.ArchieDurationModule;
import com.nedap.archie.json.DontSerializePathMixin;
import com.nedap.archie.json.FixArchetypeIDMixin;
import com.nedap.archie.json.OpenEHRTypeNaming;
import com.nedap.archie.json.RMJacksonConfiguration;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JacksonUtil {
    private static final ConcurrentHashMap<RMJacksonConfiguration, ObjectMapper> objectMapperByConfiguration = new ConcurrentHashMap();
    private static final String DEFAULT_TYPE_PARAMETER = "@type";

    public static ObjectMapper getObjectMapper() {
        return JacksonUtil.getObjectMapper(new RMJacksonConfiguration());
    }

    public static ObjectMapper getObjectMapper(RMJacksonConfiguration configuration) {
        ObjectMapper objectMapper = objectMapperByConfiguration.get(configuration);
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            JacksonUtil.configureObjectMapper(objectMapper, configuration);
            objectMapperByConfiguration.put(configuration, objectMapper);
        }
        return objectMapper;
    }

    public static void configureObjectMapper(ObjectMapper objectMapper) {
        JacksonUtil.configureObjectMapper(objectMapper, new RMJacksonConfiguration());
    }

    public static void configureObjectMapper(ObjectMapper objectMapper, final RMJacksonConfiguration configuration) {
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.enable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        objectMapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.enable(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (!configuration.isSerializeEmptyCollections()) {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        }
        if (configuration.isFailOnUnknownProperties()) {
            objectMapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        } else {
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new ArchieDurationModule());
        SimpleModule module = new SimpleModule();
        if (!configuration.isAddExtraFieldsInArchetypeId()) {
            module.setMixInAnnotation(ArchetypeID.class, FixArchetypeIDMixin.class);
        }
        if (!configuration.isAddPathProperty()) {
            module.setMixInAnnotation(Pathable.class, DontSerializePathMixin.class);
        }
        if (!configuration.isAddPathProperty() || !configuration.isAddExtraFieldsInArchetypeId()) {
            objectMapper.registerModule((Module)module);
        }
        objectMapper.enable(new MapperFeature[]{MapperFeature.USE_BASE_TYPE_AS_DEFAULT_IMPL});
        StdTypeResolverBuilder typeResolverBuilder = new ArchieTypeResolverBuilder(configuration).init(JsonTypeInfo.Id.NAME, (TypeIdResolver)new OpenEHRTypeNaming()).typeProperty(configuration.getTypePropertyName()).typeIdVisibility(true).inclusion(JsonTypeInfo.As.PROPERTY);
        objectMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
                if (propertyName.equalsIgnoreCase(configuration.getTypePropertyName())) {
                    return true;
                }
                return super.handleUnknownProperty(ctxt, p, deserializer, beanOrClass, propertyName);
            }
        });
        objectMapper.setDefaultTyping((TypeResolverBuilder)typeResolverBuilder);
    }

    static class ArchieTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        private Set<Class> classesToNotAddTypeProperty = new HashSet<Class>();

        public ArchieTypeResolverBuilder(RMJacksonConfiguration configuration) {
            super(ObjectMapper.DefaultTyping.NON_FINAL, (PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfBaseType(OpenEHRBase.class).build());
            if (!configuration.isAlwaysIncludeTypeProperty()) {
                List allTypes = ArchieRMInfoLookup.getInstance().getAllTypes();
                for (RMTypeInfo type : allTypes) {
                    if (!type.getDirectDescendantClasses().isEmpty()) continue;
                    this.classesToNotAddTypeProperty.add(type.getJavaClass());
                }
            }
        }

        public boolean useForType(JavaType t) {
            return OpenEHRBase.class.isAssignableFrom(t.getRawClass()) && !this.classesToNotAddTypeProperty.contains(t.getRawClass());
        }
    }
}

