/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.xml.adapters;

import com.nedap.archie.xml.types.StringDictionaryItem;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StringDictionaryUtil {
    public static ArrayList<StringDictionaryItem> convertUriMapIntoStringDictionaryList(Map<String, URI> terms) {
        if (terms == null) {
            return null;
        }
        ArrayList<StringDictionaryItem> items = new ArrayList<StringDictionaryItem>();
        for (String termId : terms.keySet()) {
            StringDictionaryItem item = new StringDictionaryItem();
            item.setId(termId);
            item.setValue(terms.get(termId).toString());
            items.add(item);
        }
        return items;
    }

    public static ArrayList<StringDictionaryItem> convertStringMapIntoStringDictionaryList(Map<String, String> terms) {
        if (terms == null) {
            return null;
        }
        ArrayList<StringDictionaryItem> items = new ArrayList<StringDictionaryItem>();
        for (String termId : terms.keySet()) {
            StringDictionaryItem item = new StringDictionaryItem();
            item.setId(termId);
            item.setValue(terms.get(termId));
            items.add(item);
        }
        return items;
    }

    public static Map<String, URI> convertStringDictionaryListToUriMap(List<StringDictionaryItem> items) throws URISyntaxException {
        if (items == null) {
            return null;
        }
        LinkedHashMap<String, URI> termMap = new LinkedHashMap<String, URI>();
        for (StringDictionaryItem term : items) {
            termMap.put(term.getId(), new URI(term.getValue()));
        }
        return termMap;
    }

    public static Map<String, String> convertStringDictionaryListToStringMap(List<StringDictionaryItem> items) {
        if (items == null) {
            return null;
        }
        LinkedHashMap<String, String> termMap = new LinkedHashMap<String, String>();
        for (StringDictionaryItem term : items) {
            termMap.put(term.getId(), term.getValue());
        }
        return termMap;
    }
}

