/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.xml.adapters;

import com.nedap.archie.aom.ResourceDescription;
import com.nedap.archie.aom.ResourceDescriptionItem;
import com.nedap.archie.xml.adapters.StringDictionaryUtil;
import com.nedap.archie.xml.types.XmlResourceDescription;
import com.nedap.archie.xml.types.XmlResourceDescriptionItem;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ResourceDescriptionAdapter
extends XmlAdapter<XmlResourceDescription, ResourceDescription> {
    public ResourceDescription unmarshal(XmlResourceDescription v) throws Exception {
        ResourceDescription result = new ResourceDescription();
        result.setConversionDetails(StringDictionaryUtil.convertStringDictionaryListToStringMap(v.getConversionDetails()));
        result.setCopyright(v.getCopyright());
        result.setCustodianNamespace(v.getCustodianNamespace());
        result.setCustodianOrganisation(v.getCustodianOrganisation());
        result.setDetails(this.convertDetails(v.getDetails()));
        result.setIpAcknowledgements(StringDictionaryUtil.convertStringDictionaryListToStringMap(v.getIpAcknowledgements()));
        result.setLicence(v.getLicence());
        result.setLifecycleState(v.getLifecycleState());
        result.setOriginalAuthor(StringDictionaryUtil.convertStringDictionaryListToStringMap(v.getOriginalAuthor()));
        result.setOriginalNamespace(v.getOriginalNamespace());
        result.setOriginalPublisher(v.getOriginalPublisher());
        result.setOtherContributors(v.getOtherContributors());
        result.setReferences(StringDictionaryUtil.convertStringDictionaryListToStringMap(v.getReferences()));
        result.setResourcePackageUri(v.getResourcePackageUri());
        return result;
    }

    public XmlResourceDescription marshal(ResourceDescription v) throws Exception {
        XmlResourceDescription result = new XmlResourceDescription();
        result.setConversionDetails(StringDictionaryUtil.convertStringMapIntoStringDictionaryList(v.getConversionDetails()));
        result.setCopyright(v.getCopyright());
        result.setCustodianNamespace(v.getCustodianNamespace());
        result.setCustodianOrganisation(v.getCustodianOrganisation());
        result.setDetails(this.convertDetails(v.getDetails()));
        result.setIpAcknowledgements(StringDictionaryUtil.convertStringMapIntoStringDictionaryList(v.getIpAcknowledgements()));
        result.setLicence(v.getLicence());
        result.setLifecycleState(v.getLifecycleState());
        result.setOriginalAuthor(StringDictionaryUtil.convertStringMapIntoStringDictionaryList(v.getOriginalAuthor()));
        result.setOriginalNamespace(v.getOriginalNamespace());
        result.setOriginalPublisher(v.getOriginalPublisher());
        result.setOtherContributors(v.getOtherContributors());
        result.setReferences(StringDictionaryUtil.convertStringMapIntoStringDictionaryList(v.getReferences()));
        result.setResourcePackageUri(v.getResourcePackageUri());
        return result;
    }

    private List<XmlResourceDescriptionItem> convertDetails(Map<String, ResourceDescriptionItem> details) {
        ArrayList<XmlResourceDescriptionItem> result = new ArrayList<XmlResourceDescriptionItem>();
        for (ResourceDescriptionItem item : details.values()) {
            XmlResourceDescriptionItem xmlItem = new XmlResourceDescriptionItem();
            xmlItem.setKeywords(item.getKeywords());
            xmlItem.setLanguage(item.getLanguage());
            xmlItem.setMisuse(item.getMisuse());
            xmlItem.setOriginalResourceUri(StringDictionaryUtil.convertUriMapIntoStringDictionaryList(item.getOriginalResourceUri()));
            xmlItem.setOtherDetails(StringDictionaryUtil.convertStringMapIntoStringDictionaryList(item.getOtherDetails()));
            xmlItem.setPurpose(item.getPurpose());
            xmlItem.setUse(item.getUse());
            result.add(xmlItem);
        }
        return result;
    }

    private Map<String, ResourceDescriptionItem> convertDetails(List<XmlResourceDescriptionItem> xmlDetails) {
        LinkedHashMap<String, ResourceDescriptionItem> result = new LinkedHashMap<String, ResourceDescriptionItem>();
        for (XmlResourceDescriptionItem xmlItem : xmlDetails) {
            ResourceDescriptionItem item = new ResourceDescriptionItem();
            item.setKeywords(xmlItem.getKeywords());
            item.setLanguage(xmlItem.getLanguage());
            item.setMisuse(xmlItem.getMisuse());
            try {
                item.setOriginalResourceUri(StringDictionaryUtil.convertStringDictionaryListToUriMap(xmlItem.getOriginalResourceUri()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            item.setOtherDetails(StringDictionaryUtil.convertStringDictionaryListToStringMap(xmlItem.getOtherDetails()));
            item.setPurpose(xmlItem.getPurpose());
            item.setUse(xmlItem.getUse());
            result.put(item.getLanguage().getCodeString(), item);
        }
        return result;
    }
}

