/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.xml.adapters;

import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.datetime.DateTimeSerializerFormatters;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateTimeXmlAdapter
extends XmlAdapter<String, TemporalAccessor> {
    public TemporalAccessor unmarshal(String stringValue) {
        return stringValue != null ? DateTimeParsers.parseDateTimeValue((String)stringValue) : null;
    }

    public String marshal(TemporalAccessor value) {
        if (value instanceof LocalDateTime || value instanceof ZonedDateTime || value instanceof OffsetDateTime) {
            return value.toString();
        }
        return DateTimeSerializerFormatters.ISO_8601_DATE_TIME.format(value);
    }
}

