/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.constraints.CComplexObjectSerializer;

public class CArchetypeRootSerializer
extends CComplexObjectSerializer<CArchetypeRoot> {
    public CArchetypeRootSerializer(ADLDefinitionSerializer serializer) {
        super(serializer);
    }

    @Override
    public void serialize(CArchetypeRoot cobj) {
        this.builder.indent().newline();
        this.appendSiblingOrder(cobj);
        this.builder.append("use_archetype");
        this.builder.append(" ").append(cobj.getRmTypeName());
        this.builder.append("[");
        boolean nodeIdAppended = false;
        if (cobj.getNodeId() != null) {
            nodeIdAppended = true;
            this.builder.append(cobj.getNodeId());
        }
        if (cobj.getArchetypeRef() != null) {
            if (nodeIdAppended) {
                this.builder.append(", ");
            }
            this.builder.append(cobj.getArchetypeRef());
        }
        this.builder.append("]");
        this.appendOccurrences(cobj);
        if (cobj.getAttributes() != null && !cobj.getAttributes().isEmpty()) {
            this.builder.ensureSpace();
            this.builder.append("matches {");
            this.builder.lineComment(this.serializer.getTermText(cobj));
            this.buildAttributesAndTuples(cobj);
            this.builder.append("}");
        }
        this.builder.unindent();
    }
}

