/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl;

import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.primitives.CBoolean;
import com.nedap.archie.aom.primitives.CDate;
import com.nedap.archie.aom.primitives.CDateTime;
import com.nedap.archie.aom.primitives.CDuration;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CReal;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.primitives.CTime;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.serializer.adl.ADLStringBuilder;
import com.nedap.archie.serializer.adl.constraints.ArchetypeSlotSerializer;
import com.nedap.archie.serializer.adl.constraints.CArchetypeRootSerializer;
import com.nedap.archie.serializer.adl.constraints.CBooleanSerializer;
import com.nedap.archie.serializer.adl.constraints.CComplexObjectProxySerializer;
import com.nedap.archie.serializer.adl.constraints.CComplexObjectSerializer;
import com.nedap.archie.serializer.adl.constraints.CDateSerializer;
import com.nedap.archie.serializer.adl.constraints.CDateTimeSerializer;
import com.nedap.archie.serializer.adl.constraints.CDurationSerializer;
import com.nedap.archie.serializer.adl.constraints.CIntegerSerializer;
import com.nedap.archie.serializer.adl.constraints.CRealSerializer;
import com.nedap.archie.serializer.adl.constraints.CStringSerializer;
import com.nedap.archie.serializer.adl.constraints.CTerminologyCodeSerializer;
import com.nedap.archie.serializer.adl.constraints.CTimeSerializer;
import com.nedap.archie.serializer.adl.constraints.ConstraintSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ADLDefinitionSerializer {
    protected final ADLStringBuilder builder;
    private final Map<Class, ConstraintSerializer> constraintSerializers;

    public ADLDefinitionSerializer(ADLStringBuilder builder) {
        this.builder = builder;
        this.constraintSerializers = new HashMap<Class, ConstraintSerializer>();
        this.constraintSerializers.put(ArchetypeSlot.class, new ArchetypeSlotSerializer(this));
        this.constraintSerializers.put(CArchetypeRoot.class, new CArchetypeRootSerializer(this));
        this.constraintSerializers.put(CBoolean.class, new CBooleanSerializer(this));
        this.constraintSerializers.put(CComplexObject.class, new CComplexObjectSerializer(this));
        this.constraintSerializers.put(CComplexObjectProxy.class, new CComplexObjectProxySerializer(this));
        this.constraintSerializers.put(CDate.class, new CDateSerializer(this));
        this.constraintSerializers.put(CDateTime.class, new CDateTimeSerializer(this));
        this.constraintSerializers.put(CDuration.class, new CDurationSerializer(this));
        this.constraintSerializers.put(CInteger.class, new CIntegerSerializer(this));
        this.constraintSerializers.put(CReal.class, new CRealSerializer(this));
        this.constraintSerializers.put(CString.class, new CStringSerializer(this));
        this.constraintSerializers.put(CTerminologyCode.class, new CTerminologyCodeSerializer(this));
        this.constraintSerializers.put(CTime.class, new CTimeSerializer(this));
    }

    public static String serialize(CObject cons) {
        ADLStringBuilder builder = new ADLStringBuilder();
        ADLDefinitionSerializer serializer = new ADLDefinitionSerializer(builder);
        serializer.appendCObject(cons);
        return builder.toString();
    }

    public ADLStringBuilder getBuilder() {
        return this.builder;
    }

    public String getTermText(CObject cobj) {
        String originalLanguage = Optional.ofNullable(cobj).flatMap(c -> Optional.ofNullable(c.getArchetype())).flatMap(a -> Optional.ofNullable(a.getOriginalLanguage())).map(TerminologyCode::getCodeString).orElse(null);
        if (originalLanguage == null) {
            return null;
        }
        ArchetypeTerm term = cobj.getArchetype().getTerm(cobj, originalLanguage);
        if (term == null) {
            return null;
        }
        return term.getText();
    }

    public void appendCObject(CObject cobj) {
        ConstraintSerializer<CObject> serializer = this.getSerializer(cobj);
        if (serializer == null) {
            throw new AssertionError((Object)("Unsupported constraint: " + cobj.getClass().getName()));
        }
        serializer.serialize(cobj);
    }

    public boolean isEmpty(CObject cobj) {
        ConstraintSerializer<CObject> serializer = this.getSerializer(cobj);
        return serializer != null && serializer.isEmpty(cobj);
    }

    public String getSimpleCommentText(CObject cobj) {
        ConstraintSerializer<CObject> serializer = this.getSerializer(cobj);
        if (serializer == null) {
            return null;
        }
        return serializer.getSimpleCommentText(cobj);
    }

    private ConstraintSerializer<CObject> getSerializer(CObject cobj) {
        return this.constraintSerializers.get(cobj.getClass());
    }
}

