/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public enum OperatorKind {
    eq("="),
    ne("!=", "\u2260"),
    le("<=", "\u2264"),
    lt("<"),
    ge(">=", "\u2265"),
    gt(">"),
    matches("matches", "\u2208", "is_in"),
    not("not", "!", "\u223c", "\u00ac"),
    and("and", "\u2227"),
    or("or", "\u2228"),
    xor("xor", "\u22bb"),
    implies("implies", "\u21d2"),
    for_all("for_all", "\u2200", "every"),
    exists("exists", "\u2203"),
    plus("+"),
    minus("-"),
    multiply("*"),
    divide("/"),
    modulo("%"),
    exponent("^");

    private Set<String> codes;

    private OperatorKind(String ... items) {
        this.codes = ImmutableSet.copyOf((Object[])items);
    }

    public String getDefaultCode() {
        return this.codes.iterator().next();
    }

    public static OperatorKind parse(String operatorString) {
        operatorString = operatorString.toLowerCase();
        for (OperatorKind operator : OperatorKind.values()) {
            if (!operator.codes.contains(operatorString)) continue;
            return operator;
        }
        return null;
    }
}

