/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.terminology;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.nedap.archie.aom.ArchetypeModelObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@JsonPropertyOrder(value={"text", "description", "other_items"})
@JsonIgnoreProperties(value={"@type"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="ARCHETYPE_TERM")
public class ArchetypeTerm
extends ArchetypeModelObject
implements Map<String, String> {
    private String code;
    private Map<String, String> items = new ConcurrentHashMap<String, String>();

    @XmlAttribute(name="id")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty
    public String getText() {
        return this.items.get("text");
    }

    @JsonProperty
    public String getDescription() {
        return this.items.get("description");
    }

    public void setText(String text) {
        this.items.put("text", text);
    }

    public void setDescription(String description) {
        this.items.put("description", description);
    }

    public ArchetypeTerm() {
    }

    public ArchetypeTerm(String code, String text, String description) {
        this.code = code;
        this.setText(text);
        this.setDescription(description);
    }

    @XmlTransient
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getOtherItems() {
        HashMap<String, String> otherItems = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.items.entrySet()) {
            if (entry.getKey().equals("text") || entry.getKey().equals("description")) continue;
            otherItems.put(entry.getKey(), entry.getValue());
        }
        return otherItems;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.items.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.items.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.items.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.items.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.items.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.items.putAll(m);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.items.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.items.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.items.entrySet();
    }
}

