/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.primitives;

import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.base.Interval;
import java.util.function.BiFunction;

public abstract class COrdered<T>
extends CPrimitiveObject<Interval<T>, T> {
    @Override
    public boolean isValidValue(T value) {
        if (this.getConstraint().isEmpty()) {
            return true;
        }
        for (Interval constraint : this.getConstraint()) {
            if (!constraint.has(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        if (!super.cConformsTo(other, rmTypesConformant)) {
            return false;
        }
        COrdered otherOrdered = (COrdered)other;
        if (otherOrdered.getConstraint().isEmpty()) {
            return true;
        }
        for (Interval constraint : this.getConstraint()) {
            boolean found = false;
            for (Interval otherConstraint : otherOrdered.getConstraint()) {
                if (!otherConstraint.contains(constraint).booleanValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

