/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.nedap.archie.aom.CDefinedObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.rminfo.ArchieModelNamingStrategy;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="C_PRIMITIVE_OBJECT")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class CPrimitiveObject<Constraint, ValueType>
extends CDefinedObject<ValueType> {
    public static final String PRIMITIVE_NODE_ID_VALUE = "id9999";
    private Boolean enumeratedTypeConstraint;

    public abstract ValueType getAssumedValue();

    public abstract void setAssumedValue(ValueType var1);

    public abstract List<Constraint> getConstraint();

    public abstract void setConstraint(List<Constraint> var1);

    public abstract void addConstraint(Constraint var1);

    public Boolean getEnumeratedTypeConstraint() {
        return this.enumeratedTypeConstraint;
    }

    public void setEnumeratedTypeConstraint(Boolean enumeratedTypeConstraint) {
        this.enumeratedTypeConstraint = enumeratedTypeConstraint;
    }

    @Override
    public String getNodeId() {
        return PRIMITIVE_NODE_ID_VALUE;
    }

    @Override
    public void setNodeId(String nodeId) {
        if (!nodeId.equals(PRIMITIVE_NODE_ID_VALUE)) {
            throw new UnsupportedOperationException("Cannot set node id on a CPrimitiveObject");
        }
    }

    public boolean isValidValue(ValueType value) {
        if (this.getConstraint().isEmpty()) {
            return true;
        }
        for (Constraint constraint : this.getConstraint()) {
            if (!Objects.equals(constraint, value)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidValue(ModelInfoLookup lookup, Object value) {
        Object convertedValue = lookup.convertToConstraintObject(value, this);
        return this.isValidValue(convertedValue);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        boolean first = true;
        for (Constraint constraint : this.getConstraint()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            if (constraint instanceof String) {
                result.append('\"');
                result.append(((String)constraint).replace("\"", "\\\""));
                result.append('\"');
                continue;
            }
            result.append(constraint.toString());
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public boolean cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        if (other instanceof CPrimitiveObject && other.getClass().equals(this.getClass())) {
            if (other == null) {
                return false;
            }
            return this.occurrencesConformsTo(other) && this.getRmTypeName().equalsIgnoreCase(other.getRmTypeName());
        }
        return false;
    }

    public String constrainedTypename() {
        return ArchieModelNamingStrategy.snakeCaseStrategy.translate(this.getClass().getSimpleName().substring(1));
    }

    @Override
    public String getRmTypeName() {
        return this.constrainedTypename();
    }

    public boolean hasAssumedValue() {
        return this.getAssumedValue() != null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

