/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.ArchieLanguageConfiguration;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.paths.PathSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="C_OBJECT", propOrder={"occurrences", "siblingOrder"})
public abstract class CObject
extends ArchetypeConstraint {
    @XmlAttribute(name="rm_type_name")
    private String rmTypeName;
    @XmlElement(name="occurrences")
    private MultiplicityInterval occurrences;
    @XmlAttribute(name="node_id")
    private String nodeId;
    @XmlAttribute(name="is_deprecated")
    private Boolean deprecated;
    @XmlElement(name="sibling_order")
    private SiblingOrder siblingOrder;

    public String getRmTypeName() {
        return this.rmTypeName;
    }

    public void setRmTypeName(String rmTypeName) {
        this.rmTypeName = rmTypeName;
    }

    public MultiplicityInterval getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(MultiplicityInterval occurrences) {
        this.occurrences = occurrences;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public SiblingOrder getSiblingOrder() {
        return this.siblingOrder;
    }

    public void setSiblingOrder(SiblingOrder siblingOrder) {
        this.siblingOrder = siblingOrder;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        CAttribute parent = this.getParent();
        if (parent == null) {
            return new ArrayList<PathSegment>();
        }
        List<PathSegment> segments = parent.getPathSegments();
        if (!segments.isEmpty()) {
            segments.get(segments.size() - 1).setNodeId(this.getNodeId());
        }
        return segments;
    }

    public ArchetypeTerm getTerm() {
        if (this.nodeId == null) {
            return null;
        }
        Archetype archetype = this.getArchetype();
        if (archetype == null) {
            return null;
        }
        ArchetypeTerm result = archetype.getTerm(this, ArchieLanguageConfiguration.getMeaningAndDescriptionLanguage());
        if (result == null) {
            result = archetype.getTerm(this, ArchieLanguageConfiguration.getDefaultMeaningAndDescriptionLanguage());
        }
        if (result == null && archetype.getOriginalLanguage() != null && archetype.getOriginalLanguage().getCodeString() != null) {
            result = archetype.getTerm(this, archetype.getOriginalLanguage().getCodeString());
        }
        return result;
    }

    private void setTerm(ArchetypeTerm term) {
    }

    @JsonIgnore
    @XmlTransient
    public String getMeaning() {
        ArchetypeTerm termDefinition = this.getTerm();
        if (termDefinition != null && termDefinition.getText() != null) {
            return termDefinition.getText();
        }
        return null;
    }

    @JsonIgnore
    @XmlTransient
    public String getDescription() {
        ArchetypeTerm termDefinition = this.getTerm();
        if (termDefinition != null && termDefinition.getDescription() != null) {
            return termDefinition.getDescription();
        }
        return null;
    }

    private String getLogicalPathMeaning() {
        if (this.nodeId == null) {
            return null;
        }
        String meaning = null;
        Archetype archetype = this.getArchetype();
        if (archetype == null) {
            return null;
        }
        ArchetypeTerm termDefinition = archetype.getTerm(this, ArchieLanguageConfiguration.getLogicalPathLanguage());
        if (termDefinition != null && termDefinition.getText() != null) {
            meaning = termDefinition.getText();
        }
        return meaning;
    }

    @Override
    public String getLogicalPath() {
        if (this.getParent() == null) {
            return "/";
        }
        String nodeName = this.getLogicalPathMeaning();
        if (nodeName == null) {
            nodeName = this.nodeId;
        }
        String path = this.getParent().getLogicalPath();
        if (nodeName != null) {
            path = path + "[" + nodeName + "]";
        }
        if (path.startsWith("//")) {
            return path.substring(1);
        }
        return path;
    }

    public boolean isAllowed() {
        if (this.occurrences == null) {
            return true;
        }
        return this.occurrences.isUpperUnbounded() || (Integer)this.occurrences.getUpper() > 0;
    }

    @Override
    public CAttribute getParent() {
        return (CAttribute)super.getParent();
    }

    public boolean isRequired() {
        if (this.occurrences == null) {
            return false;
        }
        return (Integer)this.occurrences.getLower() > 0;
    }

    public CAttribute getAttribute(String name) {
        return null;
    }

    public List<CAttribute> getAttributes() {
        return Collections.EMPTY_LIST;
    }

    @JsonIgnore
    public boolean isRootNode() {
        return false;
    }

    public Integer specialisationDepth() {
        return AOMUtils.getSpecializationDepthFromCode(this.nodeId);
    }

    public String toString() {
        return "CObject: " + this.getRmTypeName() + "[" + this.getNodeId() + "]";
    }

    public boolean isProhibited() {
        return this.occurrences != null && this.occurrences.isProhibited();
    }

    public boolean cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        return this.nodeIdConformsTo(other) && this.occurrencesConformsTo(other) && this.typeNameConformsTo(other, rmTypesConformant);
    }

    public boolean typeNameConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        if (other.getRmTypeName() == null || this.getRmTypeName() == null) {
            return true;
        }
        if (other.getRmTypeName().equalsIgnoreCase(this.getRmTypeName())) {
            return true;
        }
        return rmTypesConformant.apply(this.getRmTypeName(), other.getRmTypeName());
    }

    public boolean nodeIdConformsTo(CObject other) {
        return AOMUtils.codesConformant(this.getNodeId(), other.getNodeId());
    }

    public boolean occurrencesConformsTo(CObject other) {
        if (this.occurrences != null && other.occurrences != null) {
            return other.occurrences.contains((Interval)this.occurrences);
        }
        return true;
    }

    public MultiplicityInterval effectiveOccurrences(BiFunction<String, String, MultiplicityInterval> referenceModelPropMultiplicity) {
        if (this.getOccurrences() != null) {
            return this.getOccurrences();
        }
        return this.getDefaultRMOccurrences(referenceModelPropMultiplicity);
    }

    public MultiplicityInterval getDefaultRMOccurrences(BiFunction<String, String, MultiplicityInterval> referenceModelPropMultiplicity) {
        CAttribute parent = this.getParent();
        if (parent != null) {
            if (parent.getCardinality() != null && parent.getCardinality().getInterval() != null) {
                if (parent.getCardinality().getInterval().isUpperUnbounded()) {
                    return MultiplicityInterval.createOpen();
                }
                return MultiplicityInterval.createBounded((int)0, (int)((Integer)parent.getCardinality().getInterval().getUpper()));
            }
            if (parent.getParent() != null) {
                MultiplicityInterval multiplicity = referenceModelPropMultiplicity.apply(parent.getParent().getRmTypeName(), parent.getDifferentialPath() == null ? parent.getRmAttributeName() : parent.getDifferentialPath());
                if (multiplicity == null) {
                    return null;
                }
                if (multiplicity.isUpperUnbounded()) {
                    return MultiplicityInterval.createOpen();
                }
                return MultiplicityInterval.createBounded((int)0, (int)((Integer)multiplicity.getUpper()));
            }
            return MultiplicityInterval.createOpen();
        }
        return MultiplicityInterval.createOpen();
    }
}

