/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.query.APathQuery;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@JsonPropertyOrder(value={"@type", "rm_attribute_name", "path", "logical_path", "differential_path", "multiple", "mandatory", "existence", "cardinality", "children"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="C_ATTRIBUTE", propOrder={"existence", "differentialPath", "multiple", "cardinality", "children"})
public class CAttribute
extends ArchetypeConstraint {
    @XmlAttribute(name="rm_attribute_name")
    private String rmAttributeName;
    private MultiplicityInterval existence;
    @XmlElement(name="differential_path")
    private String differentialPath;
    @XmlElement(name="is_multiple")
    private boolean multiple;
    private Cardinality cardinality;
    private List<CObject> children = new ArrayList<CObject>();

    public CAttribute() {
    }

    public CAttribute(String rmAttributeName) {
        this.rmAttributeName = rmAttributeName;
    }

    public String getRmAttributeName() {
        return this.rmAttributeName;
    }

    public void setRmAttributeName(String rmAttributeName) {
        this.rmAttributeName = rmAttributeName;
    }

    public MultiplicityInterval getExistence() {
        return this.existence;
    }

    public void setExistence(MultiplicityInterval existence) {
        this.existence = existence;
    }

    public String getDifferentialPath() {
        return this.differentialPath;
    }

    public void setDifferentialPath(String differentialPath) {
        this.differentialPath = differentialPath;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public CObject getChild(String nodeId) {
        CObject result = this.getChild(nodeId, false);
        if (result == null) {
            result = this.getChild(nodeId, true);
        }
        return result;
    }

    public CObject getPossiblySpecializedChild(String nodeId) {
        CObject result = this.getChild(nodeId, false);
        if (result != null) {
            return result;
        }
        for (CObject child : this.children) {
            if (nodeId.equals(child.getNodeId()) || AOMUtils.codesConformant(child.getNodeId(), nodeId)) {
                return child;
            }
            if (!(child instanceof CArchetypeRoot) || !((CArchetypeRoot)child).getArchetypeRef().equals(nodeId)) continue;
            return child;
        }
        return null;
    }

    private CObject getChild(String nodeId, boolean lookThroughProxies) {
        for (CObject child : this.children) {
            String targetPath;
            APathQuery aPathQuery;
            PathSegment lastPathSegment;
            if (nodeId.equals(child.getNodeId())) {
                return child;
            }
            if (!(child instanceof CArchetypeRoot ? ((CArchetypeRoot)child).getArchetypeRef().equals(nodeId) : lookThroughProxies && child instanceof CComplexObjectProxy && (lastPathSegment = (PathSegment)(aPathQuery = new APathQuery(targetPath = ((CComplexObjectProxy)child).getTargetPath())).getPathSegments().get(aPathQuery.getPathSegments().size() - 1)).hasIdCode() && lastPathSegment.getNodeId().equals(nodeId))) continue;
            return child;
        }
        return null;
    }

    public CObject getChildByMeaning(String meaning) {
        meaning = meaning.toLowerCase();
        for (CObject child : this.children) {
            String childMeaning = child.getMeaning();
            if (childMeaning == null || !meaning.equals(childMeaning = childMeaning.toLowerCase())) continue;
            return child;
        }
        return null;
    }

    public List<CObject> getChildren() {
        return this.children;
    }

    public void setChildren(List<CObject> children) {
        if (children == null) {
            this.children = new ArrayList<CObject>();
        } else {
            this.children = children;
            for (CObject child : children) {
                child.setParent(this);
            }
        }
    }

    public void addChild(CObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(CObject child, SiblingOrder order) {
        if (order != null && order.getSiblingNodeId() != null) {
            CObject sibling = this.getChild(order.getSiblingNodeId());
            int siblingIndex = this.getChildren().indexOf(sibling);
            if (siblingIndex > -1) {
                if (!order.isBefore()) {
                    ++siblingIndex;
                }
                this.children.add(siblingIndex, child);
            } else {
                this.children.add(child);
            }
        } else {
            this.children.add(child);
        }
        child.setParent(this);
    }

    public void replaceChild(String nodeId, CObject constraint) {
        int index = this.getIndexOfChildWithNodeId(nodeId);
        if (index > -1) {
            this.children.set(index, constraint);
            constraint.setParent(this);
        } else {
            this.addChild(constraint);
        }
    }

    public void removeChild(String nodeId) {
        int index = this.getIndexOfChildWithNodeId(nodeId);
        if (index > -1) {
            this.children.remove(index);
        }
    }

    public void removeChild(CObject child) {
        int index = this.getIndexOfMatchingCObjectChild(child);
        if (index > -1) {
            this.children.remove(index);
        }
    }

    public void replaceChildren(String nodeId, List<CObject> newChildren, boolean keepOriginal) {
        int index = this.getIndexOfChildWithNodeId(nodeId);
        if (index > -1) {
            List<CObject> childrenBefore = this.children.subList(0, index + 1);
            if (!keepOriginal) {
                childrenBefore.remove(index);
            }
            childrenBefore.addAll(newChildren);
            for (CObject constraint : newChildren) {
                constraint.setParent(this);
            }
        } else {
            for (CObject constraint : newChildren) {
                this.addChild(constraint);
            }
        }
    }

    public int getIndexOfMatchingCObjectChild(CObject child) {
        if (child instanceof CPrimitiveObject) {
            return this.getIndexOfChildWithMatchingRmTypeName(child.getRmTypeName());
        }
        return this.getIndexOfChildWithNodeId(child.getNodeId());
    }

    public int getIndexOfChildWithMatchingRmTypeName(String rmTypeName) {
        for (int i = 0; i < this.children.size(); ++i) {
            CObject child = this.children.get(i);
            if (!rmTypeName.equals(child.getRmTypeName())) continue;
            return i;
        }
        return -1;
    }

    public int getIndexOfChildWithNodeId(String nodeId) {
        for (int i = 0; i < this.children.size(); ++i) {
            CObject child = this.children.get(i);
            if (!nodeId.equals(child.getNodeId())) continue;
            return i;
        }
        return -1;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    public String toString() {
        return "Cattribute: " + this.rmAttributeName + ", " + this.children.size() + " children";
    }

    @Override
    public List<PathSegment> getPathSegments() {
        CObject parent = this.getParent();
        if (parent == null) {
            return new ArrayList<PathSegment>();
        }
        List<PathSegment> segments = parent.getPathSegments();
        if (this.differentialPath == null) {
            segments.add(new PathSegment(this.getRmAttributeName()));
        } else {
            segments.addAll(new APathQuery(this.differentialPath).getPathSegments());
        }
        return segments;
    }

    @Override
    public CObject getParent() {
        return (CObject)super.getParent();
    }

    @Override
    public String getLogicalPath() {
        String path = "/" + this.rmAttributeName;
        if (this.getParent() != null) {
            path = this.getParent().getLogicalPath() + path;
        }
        if (path.startsWith("//")) {
            return path.substring(1);
        }
        return path;
    }

    @Override
    public CAttribute clone() {
        return (CAttribute)super.clone();
    }

    @JsonIgnore
    @XmlTransient
    public boolean isSingle() {
        return !this.multiple;
    }

    public boolean isMandatory() {
        if (this.existence != null) {
            return this.existence.isMandatory();
        }
        return false;
    }

    public boolean anyAllowed() {
        return this.children.isEmpty() && !this.isProhibited();
    }

    public boolean isProhibited() {
        if (this.existence != null) {
            return this.existence.isProhibited();
        }
        return false;
    }

    @Override
    @JsonIgnore
    public boolean isLeaf() {
        return this.children != null && this.children.size() > 0;
    }

    public Boolean cCongruentTo(CAttribute other) {
        if (other == null) {
            return false;
        }
        return this.existence == null && (this.isSingle() && other.isSingle() || this.isMultiple() && other.isMultiple() && this.cardinality == null);
    }

    public Boolean cConformsTo(CAttribute other) {
        if (other == null) {
            return false;
        }
        return this.existenceConformsTo(other) != false && (this.isSingle() && other.isSingle() || this.isMultiple() && this.cardinalityConformsTo(other) != false);
    }

    public Boolean existenceConformsTo(CAttribute other) {
        if (other == null) {
            return false;
        }
        if (this.existence != null && other.existence != null) {
            return other.existence.contains((Interval)this.existence);
        }
        return true;
    }

    public Boolean cardinalityConformsTo(CAttribute other) {
        if (other == null) {
            return false;
        }
        if (this.cardinality != null && other.cardinality != null) {
            return other.cardinality.contains(this.cardinality);
        }
        return true;
    }

    @JsonIgnore
    public boolean isSecondOrderConstrained() {
        return this.getSocParent() != null || this.getParent() != null && this.getParent().getSocParent() != null;
    }

    @JsonIgnore
    public int getAggregateOccurrencesLowerSum() {
        int sum = 0;
        for (CObject cObject : this.getChildren()) {
            if (cObject.getOccurrences() == null) continue;
            sum += ((Integer)cObject.getOccurrences().getLower()).intValue();
        }
        return sum;
    }

    @JsonIgnore
    public int getMinimumChildCount() {
        int result = 0;
        boolean foundOptional = false;
        for (CObject cObject : this.getChildren()) {
            if (cObject.isRequired()) {
                ++result;
                continue;
            }
            if (!cObject.isAllowed()) continue;
            foundOptional = true;
        }
        if (foundOptional) {
            ++result;
        }
        return result;
    }

    public List<CObject> getChildrenByRmTypeName(String rmTypeName) {
        ArrayList<CObject> result = new ArrayList<CObject>();
        for (int i = 0; i < this.children.size(); ++i) {
            CObject child = this.children.get(i);
            if (!rmTypeName.equals(child.getRmTypeName())) continue;
            result.add(child);
        }
        return result;
    }
}

