/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.LanguageSection;
import com.nedap.archie.aom.ResourceAnnotations;
import com.nedap.archie.aom.ResourceDescription;
import com.nedap.archie.aom.TranslationDetails;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import com.nedap.archie.xml.adapters.ResourceDescriptionAdapter;
import com.nedap.archie.xml.adapters.TranslationDetailsAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="AUTHORED_RESOURCE")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class AuthoredResource
extends ArchetypeModelObject {
    @Nullable
    private Boolean controlled;
    private String uid;
    @Nullable
    private ResourceDescription description;
    private LanguageSection content = new LanguageSection();
    private ResourceAnnotations annotations;

    @XmlElement(name="is_controlled")
    public Boolean getControlled() {
        return this.controlled;
    }

    public void setControlled(Boolean controlled) {
        this.controlled = controlled;
    }

    @XmlElement(name="uid")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @XmlElement(name="description")
    @XmlJavaTypeAdapter(value=ResourceDescriptionAdapter.class)
    public ResourceDescription getDescription() {
        return this.description;
    }

    public void setDescription(ResourceDescription description) {
        this.description = description;
    }

    @XmlElement(name="original_language")
    public TerminologyCode getOriginalLanguage() {
        if (this.content == null) {
            return null;
        }
        return this.content.getOriginalLanguage();
    }

    public void setOriginalLanguage(TerminologyCode originalLanguage) {
        if (this.content == null) {
            this.content = new LanguageSection();
        }
        this.content.setOriginalLanguage(originalLanguage);
    }

    @XmlTransient
    @Nullable
    public Map<String, TranslationDetails> getTranslations() {
        if (this.content == null) {
            return null;
        }
        return this.content.getTranslations();
    }

    public void setTranslations(Map<String, TranslationDetails> translations) {
        if (this.content == null) {
            this.content = new LanguageSection();
        }
        this.content.setTranslations(translations);
    }

    @XmlElement(name="translations")
    @XmlJavaTypeAdapter(value=TranslationDetailsAdapter.class)
    @JsonIgnore
    @RMPropertyIgnore
    public List<TranslationDetails> getTranslationList() {
        return new ArrayList<TranslationDetails>(this.content.getTranslations().values());
    }

    public void setTranslationList(List<TranslationDetails> translationList) {
        LinkedHashMap<String, TranslationDetails> translations = new LinkedHashMap<String, TranslationDetails>();
        for (TranslationDetails translationDetails : translationList) {
            translations.put(translationDetails.getLanguage().getCodeString(), translationDetails);
        }
        this.content.setTranslations(translations);
    }

    @XmlElement(name="annotations")
    public ResourceAnnotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(ResourceAnnotations annotations) {
        this.annotations = annotations;
    }

    @JsonIgnore
    @XmlTransient
    @RMPropertyIgnore
    public LanguageSection getAuthoredResourceContent() {
        return this.content;
    }

    public void setAuthoredResourceContent(LanguageSection content) {
        this.content = content;
    }
}

