/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ARCHETYPE_HRID", propOrder={"conceptId", "namespace", "rmPublisher", "rmPackage", "rmClass", "releaseVersion", "versionStatus", "buildCount"})
public class ArchetypeHRID
extends ArchetypeModelObject {
    private String namespace;
    @XmlAttribute(name="rm_publisher")
    private String rmPublisher;
    @XmlAttribute(name="rm_package")
    private String rmPackage;
    @XmlAttribute(name="rm_class")
    private String rmClass;
    @XmlAttribute(name="concept_id")
    private String conceptId;
    @XmlAttribute(name="release_version")
    private String releaseVersion;
    @XmlAttribute(name="version_status")
    private String versionStatus;
    @XmlAttribute(name="build_count")
    private String buildCount;
    private static final Pattern archetypeHRIDPattern = Pattern.compile("((?<namespace>.*)::)?(?<publisher>[^.-]*)-(?<package>[^.-]*)-(?<class>[^.-]*)\\.(?<concept>[^.]*)(\\.v(?<version>.*))?");

    public ArchetypeHRID() {
    }

    @JsonCreator
    public ArchetypeHRID(String value) {
        Matcher m = archetypeHRIDPattern.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException(value + " is not a valid archetype human readable id");
        }
        this.namespace = m.group("namespace");
        this.rmPublisher = m.group("publisher");
        this.rmPackage = m.group("package");
        this.rmClass = m.group("class");
        this.conceptId = m.group("concept");
        this.releaseVersion = m.group("version");
    }

    @JsonCreator
    public ArchetypeHRID(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="publisher") String rmPublisher, @JsonProperty(value="rm_package") String rmPackage, @JsonProperty(value="rm_class") String rmClass, @JsonProperty(value="concept_id") String conceptId, @JsonProperty(value="release_version") String releaseVersion, @JsonProperty(value="version_status") String versionStatus, @JsonProperty(value="build_count") String buildCount) {
        this.namespace = namespace;
        this.rmPublisher = rmPublisher;
        this.rmPackage = rmPackage;
        this.rmClass = rmClass;
        this.conceptId = conceptId;
        this.releaseVersion = releaseVersion;
        this.versionStatus = versionStatus;
        this.buildCount = buildCount;
    }

    public String getFullId() {
        StringBuilder result = new StringBuilder(30);
        result.append(this.getIdUpToConcept());
        if (this.releaseVersion == null) {
            return result.toString();
        }
        if (this.releaseVersion.startsWith("v")) {
            result.append(".");
        } else {
            result.append(".v");
        }
        result.append(this.releaseVersion);
        return result.toString();
    }

    public String getSemanticId() {
        return this.getIdUpToConcept() + (this.releaseVersion == null ? "" : ".v" + (this.releaseVersion.isEmpty() ? "" : this.getMajorVersion()));
    }

    public String getMajorVersion() {
        return this.releaseVersion == null || this.releaseVersion.isEmpty() ? null : this.releaseVersion.split("\\.")[0];
    }

    public String getMinorVersion() {
        if (this.releaseVersion == null) {
            return null;
        }
        String[] splitVersion = this.releaseVersion.split("\\.");
        return splitVersion.length >= 2 ? splitVersion[1] : null;
    }

    public String getPatchVersion() {
        if (this.releaseVersion == null) {
            return null;
        }
        String[] splitVersion = this.releaseVersion.split("\\.|\\-");
        return splitVersion.length >= 3 ? splitVersion[2] : null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRmPublisher() {
        return this.rmPublisher;
    }

    public void setRmPublisher(String rmPublisher) {
        this.rmPublisher = rmPublisher;
    }

    public String getRmPackage() {
        return this.rmPackage;
    }

    public void setRmPackage(String rmPackage) {
        this.rmPackage = rmPackage;
    }

    public String getRmClass() {
        return this.rmClass;
    }

    public void setRmClass(String rmClass) {
        this.rmClass = rmClass;
    }

    public String getConceptId() {
        return this.conceptId;
    }

    public void setConceptId(String conceptId) {
        this.conceptId = conceptId;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public String getVersionStatus() {
        return this.versionStatus;
    }

    public void setVersionStatus(String versionStatus) {
        this.versionStatus = versionStatus;
    }

    public String getBuildCount() {
        return this.buildCount;
    }

    public void setBuildCount(String buildCount) {
        this.buildCount = buildCount;
    }

    public String toString() {
        return this.getFullId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchetypeHRID other = (ArchetypeHRID)o;
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.rmPublisher, other.rmPublisher) && Objects.equals(this.rmPackage, other.rmPackage) && Objects.equals(this.rmClass, other.rmClass) && Objects.equals(this.conceptId, other.conceptId) && Objects.equals(this.releaseVersion, other.releaseVersion) && Objects.equals(this.versionStatus, other.versionStatus) && Objects.equals(this.buildCount, other.buildCount);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.rmPublisher, this.rmPackage, this.rmClass, this.conceptId, this.releaseVersion, this.versionStatus, this.buildCount);
    }

    @RMPropertyIgnore
    public String getIdUpToConcept() {
        StringBuilder result = new StringBuilder(30);
        if (!Strings.isNullOrEmpty((String)this.namespace)) {
            result.append(this.namespace);
            result.append("::");
        }
        result.append(this.rmPublisher);
        result.append("-");
        result.append(this.rmPackage);
        result.append("-");
        result.append(this.rmClass);
        result.append(".");
        result.append(this.conceptId);
        return result.toString();
    }
}

