/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.treewalkers;

import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.adlparser.treewalkers.CComplexObjectParser;
import com.nedap.archie.adlparser.treewalkers.PrimitivesConstraintParser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.rules.Assertion;
import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.Constant;
import com.nedap.archie.rules.Constraint;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.ExpressionType;
import com.nedap.archie.rules.ExpressionVariable;
import com.nedap.archie.rules.ForAllStatement;
import com.nedap.archie.rules.Function;
import com.nedap.archie.rules.ModelReference;
import com.nedap.archie.rules.OperatorKind;
import com.nedap.archie.rules.RuleStatement;
import com.nedap.archie.rules.UnaryOperator;
import com.nedap.archie.rules.VariableDeclaration;
import com.nedap.archie.rules.VariableReference;
import com.nedap.archie.serializer.odin.OdinValueParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RulesParser
extends BaseTreeWalker {
    private PrimitivesConstraintParser primitivesConstraintParser;
    public static final Pattern VARIABLE_ASSIGNMENT_PATTERN = Pattern.compile("\\$(?<name>.*)\\:(?<type>.*)");

    public RulesParser(ANTLRParserErrors errors) {
        super(errors);
        this.primitivesConstraintParser = new PrimitivesConstraintParser(errors);
    }

    public RuleStatement parse(AdlParser.AssertionContext assertionContext) {
        Assertion assertion = new Assertion();
        if (assertionContext.booleanAssertion() != null) {
            AdlParser.BooleanAssertionContext context = assertionContext.booleanAssertion();
            assertion.setStringExpression(context.getText());
            if (context.identifier() != null) {
                assertion.setTag(context.identifier().getText());
            }
            assertion.setExpression(this.parseExpression(context.expression()));
            return assertion;
        }
        if (assertionContext.variableDeclaration() != null) {
            VariableDeclaration declaration = this.parseVariableDeclaration(assertionContext.variableDeclaration());
            return declaration;
        }
        return assertion;
    }

    private VariableDeclaration parseVariableDeclaration(AdlParser.VariableDeclarationContext context) {
        ExpressionVariable result = new ExpressionVariable();
        this.setVariableNameAndType(context, result);
        result.setExpression(this.parseExpression(context.expression()));
        return result;
    }

    private void setVariableNameAndType(AdlParser.VariableDeclarationContext context, ExpressionVariable result) {
        Matcher matcher = VARIABLE_ASSIGNMENT_PATTERN.matcher(context.VARIABLE_DECLARATION().getText());
        if (!matcher.matches()) {
            throw new IllegalStateException("variable declaration does not conform to $<name>:<type>. This should have been handled in the lexer and is likely a bug in Archie: " + context.getText());
        }
        result.setName(matcher.group("name"));
        result.setType(ExpressionType.fromString(matcher.group("type")));
    }

    private Expression parseExpression(AdlParser.ExpressionContext context) {
        if (context.SYM_IMPLIES() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_IMPLIES().getText()));
            expression.addOperand(this.parseExpression(context.expression()));
            expression.addOperand(this.parseForAllExpression(context.booleanForAllExpression()));
            return expression;
        }
        return this.parseForAllExpression(context.booleanForAllExpression());
    }

    private Expression parseForAllExpression(AdlParser.BooleanForAllExpressionContext context) {
        if (context.SYM_FOR_ALL() != null) {
            Expression pathExpression = null;
            pathExpression = context.adlRulesPath() != null ? this.parseModelReference(context.adlRulesPath()) : this.parseVariableReference(context.variableReference());
            String variableName = context.identifier().getText();
            return new ForAllStatement(variableName, pathExpression, this.parseForAllExpression(context.booleanForAllExpression()));
        }
        return this.parseOrExpression(context.booleanOrExpression());
    }

    private Expression parseOrExpression(AdlParser.BooleanOrExpressionContext context) {
        if (context.SYM_OR() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_OR().getText()));
            expression.addOperand(this.parseOrExpression(context.booleanOrExpression()));
            expression.addOperand(this.parseAndExpression(context.booleanAndExpression()));
            return expression;
        }
        return this.parseAndExpression(context.booleanAndExpression());
    }

    private Expression parseAndExpression(AdlParser.BooleanAndExpressionContext context) {
        if (context.SYM_AND() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_AND().getText()));
            expression.addOperand(this.parseAndExpression(context.booleanAndExpression()));
            expression.addOperand(this.parseXorExpression(context.booleanXorExpression()));
            return expression;
        }
        return this.parseXorExpression(context.booleanXorExpression());
    }

    private Expression parseXorExpression(AdlParser.BooleanXorExpressionContext context) {
        if (context.SYM_XOR() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_XOR().getText()));
            expression.addOperand(this.parseBooleanNotExpression(context.booleanNotExpression()));
            expression.addOperand(this.parseXorExpression(context.booleanXorExpression()));
            return expression;
        }
        return this.parseBooleanNotExpression(context.booleanNotExpression());
    }

    private Expression parseBooleanNotExpression(AdlParser.BooleanNotExpressionContext context) {
        if (context.SYM_NOT() != null) {
            return new UnaryOperator(ExpressionType.BOOLEAN, OperatorKind.not, this.parseBooleanNotExpression(context.booleanNotExpression()));
        }
        return this.parseBooleanConstraintExpression(context.booleanConstraintExpression());
    }

    private Expression parseBooleanConstraintExpression(AdlParser.BooleanConstraintExpressionContext context) {
        if (context.booleanConstraint() != null) {
            return this.parseBooleanConstraint(context.booleanConstraint());
        }
        return this.parseEqualityExpression(context.equalityExpression());
    }

    private Expression parseBooleanLiteral(AdlParser.BooleanLiteralContext context) {
        return new Constant<Boolean>(ExpressionType.BOOLEAN, context.SYM_TRUE() != null);
    }

    private ModelReference parseModelReference(AdlParser.AdlRulesPathContext context) {
        String variableReference = null;
        String path = context.ADL_PATH().getText();
        if (context.SYM_VARIABLE_START() != null) {
            variableReference = CComplexObjectParser.getFirstAttributeOfPath(path);
            path = CComplexObjectParser.getPathMinusFirstAttribute(path);
        }
        return new ModelReference(variableReference, path);
    }

    private Expression parseBooleanConstraint(AdlParser.BooleanConstraintContext context) {
        ModelReference modelReference = null;
        if (context.adlRulesPath() != null) {
            modelReference = this.parseModelReference(context.adlRulesPath());
        }
        CPrimitiveObject cPrimitiveObject = null;
        cPrimitiveObject = context.c_primitive_object() != null ? this.primitivesConstraintParser.parsePrimitiveObject(context.c_primitive_object()) : this.primitivesConstraintParser.parseRegex(context.CONTAINED_REGEXP());
        return new BinaryOperator(ExpressionType.BOOLEAN, OperatorKind.matches, modelReference, new Constraint<CPrimitiveObject>(cPrimitiveObject));
    }

    private Expression parseEqualityExpression(AdlParser.EqualityExpressionContext context) {
        if (context.equalityBinop() != null) {
            Expression left = this.parseEqualityExpression(context.equalityExpression());
            Expression right = this.parseRelOpExpression(context.relOpExpression());
            if (left.getType() != null && right.getType() != null && left.getType() != right.getType()) {
                throw new IllegalArgumentException("arithmetic relop expression with different types: " + (Object)((Object)left.getType()) + " + " + (Object)((Object)right.getType()));
            }
            return new BinaryOperator(left.getType(), OperatorKind.parse(context.equalityBinop().getText()), left, right);
        }
        return this.parseRelOpExpression(context.relOpExpression());
    }

    private Expression parseRelOpExpression(AdlParser.RelOpExpressionContext context) {
        if (context.relationalBinop() != null) {
            Expression left = this.parseRelOpExpression(context.relOpExpression());
            Expression right = this.parseArithmeticExpression(context.arithmeticExpression());
            if (left.getType() != null && right.getType() != null && left.getType() != right.getType()) {
                throw new IllegalArgumentException("arithmetic relop expression with different types: " + (Object)((Object)left.getType()) + " + " + (Object)((Object)right.getType()));
            }
            return new BinaryOperator(left.getType(), OperatorKind.parse(context.relationalBinop().getText()), left, right);
        }
        return this.parseArithmeticExpression(context.arithmeticExpression());
    }

    private Expression parseArithmeticExpression(AdlParser.ArithmeticExpressionContext context) {
        if (context.plusMinusBinop() != null) {
            Expression left = this.parseArithmeticExpression((AdlParser.ArithmeticExpressionContext)context.arithmeticExpression().get(0));
            Expression right = this.parseArithmeticExpression((AdlParser.ArithmeticExpressionContext)context.arithmeticExpression().get(1));
            return new BinaryOperator(right.getType(), OperatorKind.parse(context.plusMinusBinop().getText()), left, right);
        }
        if (context.multBinop() != null) {
            Expression left = this.parseArithmeticExpression((AdlParser.ArithmeticExpressionContext)context.arithmeticExpression().get(0));
            Expression right = this.parseArithmeticExpression((AdlParser.ArithmeticExpressionContext)context.arithmeticExpression().get(1));
            return new BinaryOperator(right.getType(), OperatorKind.parse(context.multBinop().getText()), left, right);
        }
        if (context.powBinop() != null) {
            Expression left = this.parseArithmeticExpression((AdlParser.ArithmeticExpressionContext)context.arithmeticExpression().get(0));
            Expression right = this.parseArithmeticExpression((AdlParser.ArithmeticExpressionContext)context.arithmeticExpression().get(1));
            return new BinaryOperator(right.getType(), OperatorKind.parse(context.powBinop().getText()), left, right);
        }
        return this.parseExpressionLeaf(context.expressionLeaf());
    }

    private Expression parseExpressionLeaf(AdlParser.ExpressionLeafContext context) {
        if (context.integer_value() != null) {
            return new Constant<Long>(ExpressionType.INTEGER, Long.parseLong(context.integer_value().getText()));
        }
        if (context.real_value() != null) {
            return new Constant<Double>(ExpressionType.REAL, Double.parseDouble(context.real_value().getText()));
        }
        if (context.string_value() != null) {
            return new Constant<String>(ExpressionType.STRING, OdinValueParser.parseOdinStringValue((AdlParser.String_valueContext)context.string_value()));
        }
        if (context.adlRulesPath() != null) {
            ModelReference reference = this.parseModelReference(context.adlRulesPath());
            if (context.SYM_EXISTS() != null) {
                return new UnaryOperator(ExpressionType.BOOLEAN, OperatorKind.exists, reference);
            }
            return reference;
        }
        if (context.expression() != null) {
            Expression expression = this.parseExpression(context.expression());
            expression.setPrecedenceOverridden(true);
            return expression;
        }
        if (context.expressionLeaf() != null) {
            return new UnaryOperator(ExpressionType.REAL, OperatorKind.minus, this.parseExpressionLeaf(context.expressionLeaf()));
        }
        if (context.variableReference() != null) {
            return this.parseVariableReference(context.variableReference());
        }
        if (context.booleanLiteral() != null) {
            return this.parseBooleanLiteral(context.booleanLiteral());
        }
        if (context.variableReference() != null) {
            return this.parseVariableReference(context.variableReference());
        }
        if (context.functionName() != null) {
            return this.parseFunctionCall(context);
        }
        throw new IllegalArgumentException("cannot parse unknown arithmetic leaf type: " + context.getText());
    }

    private Expression parseFunctionCall(AdlParser.ExpressionLeafContext context) {
        String functionName = context.functionName().getText();
        List<Expression> arguments = this.parseArgumentList(context.argumentList());
        return new Function(functionName, arguments);
    }

    private List<Expression> parseArgumentList(AdlParser.ArgumentListContext argumentListContext) {
        ArrayList<Expression> expressions;
        if (argumentListContext == null) {
            expressions = new ArrayList<Expression>();
        } else {
            expressions = new ArrayList(argumentListContext.expression().size());
            for (AdlParser.ExpressionContext expressionContext : argumentListContext.expression()) {
                expressions.add(this.parseExpression(expressionContext));
            }
        }
        return expressions;
    }

    private Expression parseVariableReference(AdlParser.VariableReferenceContext context) {
        VariableReference reference = new VariableReference();
        VariableDeclaration declaration = new VariableDeclaration();
        declaration.setName(context.identifier().getText());
        reference.setDeclaration(declaration);
        return reference;
    }
}

