/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.treewalkers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.adl14.ADL14ConversionConfiguration;
import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.adlparser.antlr.AdlLexer;
import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.serializer.odin.AdlOdinToJsonConverter;
import java.io.IOException;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.text.StringEscapeUtils;

public class Odin14ValueParser {
    private ObjectMapper objectMapper = new ObjectMapper();

    public Odin14ValueParser(ADL14ConversionConfiguration configuration) {
        AdlOdinToJsonConverter.configureObjectMapper((ObjectMapper)this.objectMapper, (boolean)configuration.isAllowDuplicateFieldNames());
    }

    public <T> T convert(AdlParser.Odin_textContext odin, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(new AdlOdinToJsonConverter().convert(odin), clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T convert(String odin, Class<T> clazz) {
        AdlLexer adlLexer = new AdlLexer((CharStream)CharStreams.fromString((String)odin));
        AdlParser parser = new AdlParser((TokenStream)new CommonTokenStream((TokenSource)adlLexer));
        return this.convert(parser.odin_text(), clazz);
    }

    public static String parseOdinStringValue(Adl14Parser.String_valueContext context) {
        if (context == null) {
            return null;
        }
        String text = context.getText();
        if (text.startsWith("/")) {
            return text;
        }
        if (text.startsWith("^")) {
            return text;
        }
        if (!text.startsWith("\"")) {
            throw new IllegalArgumentException("text should start with '/', '^' or '\"'");
        }
        if (text.length() == 2) {
            return "";
        }
        return StringEscapeUtils.unescapeJava((String)text.substring(1, text.length() - 1));
    }
}

