/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.treewalkers;

import com.nedap.archie.adl14.ADL14ConversionConfiguration;
import com.nedap.archie.adl14.ADL14ConversionUtil;
import com.nedap.archie.adl14.aom14.ArchetypeOntology;
import com.nedap.archie.adl14.aom14.ConstraintBindingsList;
import com.nedap.archie.adl14.aom14.TermBindingsList;
import com.nedap.archie.adl14.aom14.TermCodeList;
import com.nedap.archie.adl14.treewalkers.Odin14ValueParser;
import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.base.terminology.TerminologyCode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Adl14TerminologyParser
extends BaseTreeWalker {
    private static final Logger logger = LoggerFactory.getLogger(Adl14TerminologyParser.class);
    private final Odin14ValueParser odinParser;
    private ADL14ConversionUtil conversionUtil;

    public Adl14TerminologyParser(ANTLRParserErrors errors, ADL14ConversionConfiguration configuration, Odin14ValueParser odinParser) {
        super(errors);
        this.conversionUtil = new ADL14ConversionUtil(configuration);
        this.odinParser = odinParser;
    }

    public ArchetypeTerminology parseTerminology(Adl14Parser.Terminology_sectionContext context) {
        ArchetypeOntology ontology = this.odinParser.convert(context.odin_text().getText(), ArchetypeOntology.class);
        ArchetypeTerminology terminology = new ArchetypeTerminology();
        for (String language : ontology.getTermDefinitions().keySet()) {
            terminology.getTermDefinitions().put(language, ontology.getTermDefinitions().get(language).getItems());
        }
        this.convertTermBindings(ontology, terminology);
        this.convertConstraintBindings(ontology, terminology);
        this.convertConstraintDefinitions(ontology, terminology);
        return terminology;
    }

    private void convertConstraintDefinitions(ArchetypeOntology ontology, ArchetypeTerminology terminology) {
        if (ontology.getConstraintDefinitions() != null) {
            for (Map.Entry<String, TermCodeList> constraintDefinitions : ontology.getConstraintDefinitions().entrySet()) {
                String language = constraintDefinitions.getKey();
                if (terminology.getTermDefinitions().get(language) == null) {
                    terminology.getTermDefinitions().put(language, new LinkedHashMap());
                }
                terminology.getTermDefinitions().get(language).putAll(constraintDefinitions.getValue().getItems());
            }
        }
    }

    private void convertConstraintBindings(ArchetypeOntology ontology, ArchetypeTerminology terminology) {
        if (ontology.getConstraintBindings() != null) {
            for (Map.Entry<String, ConstraintBindingsList> constraintBinding : ontology.getConstraintBindings().entrySet()) {
                this.ensureTermBindingKeyExists(terminology, constraintBinding.getKey());
                terminology.getTermBindings().get(constraintBinding.getKey()).putAll(new LinkedHashMap<String, URI>(constraintBinding.getValue().getItems()));
            }
        }
    }

    private void convertTermBindings(ArchetypeOntology ontology, ArchetypeTerminology terminology) {
        if (ontology.getTermBindings() != null) {
            for (Map.Entry<String, TermBindingsList> termBinding : ontology.getTermBindings().entrySet()) {
                this.ensureTermBindingKeyExists(terminology, termBinding.getKey());
                Map<String, URI> newBindings = terminology.getTermBindings().get(termBinding.getKey());
                if (termBinding.getValue() == null || termBinding.getValue().getItems() == null) continue;
                for (Map.Entry<String, TerminologyCode> oldBinding : termBinding.getValue().getItems().entrySet()) {
                    try {
                        URI newBindingValue = this.conversionUtil.convertToUri(oldBinding.getValue());
                        newBindings.put(oldBinding.getKey(), newBindingValue);
                    }
                    catch (URISyntaxException e) {
                        logger.warn("error converting term binding to URI", (Throwable)e);
                    }
                }
            }
        }
    }

    private void ensureTermBindingKeyExists(ArchetypeTerminology terminology, String key) {
        if (!terminology.getTermBindings().containsKey(key)) {
            terminology.getTermBindings().put(key, new LinkedHashMap());
        }
    }
}

