/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.treewalkers;

import com.nedap.archie.adl14.treewalkers.Adl14CComplexObjectParser;
import com.nedap.archie.adl14.treewalkers.Adl14PrimitivesConstraintParser;
import com.nedap.archie.adl14.treewalkers.Odin14ValueParser;
import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.rules.Assertion;
import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.Constant;
import com.nedap.archie.rules.Constraint;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.ExpressionType;
import com.nedap.archie.rules.ExpressionVariable;
import com.nedap.archie.rules.ForAllStatement;
import com.nedap.archie.rules.Function;
import com.nedap.archie.rules.ModelReference;
import com.nedap.archie.rules.OperatorKind;
import com.nedap.archie.rules.RuleStatement;
import com.nedap.archie.rules.UnaryOperator;
import com.nedap.archie.rules.VariableDeclaration;
import com.nedap.archie.rules.VariableReference;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Adl14RulesParser
extends BaseTreeWalker {
    private Adl14PrimitivesConstraintParser primitivesConstraintParser;
    public static final Pattern VARIABLE_ASSIGNMENT_PATTERN = Pattern.compile("\\$(?<name>.*)\\:(?<type>.*)");

    public Adl14RulesParser(ANTLRParserErrors errors) {
        super(errors);
        this.primitivesConstraintParser = new Adl14PrimitivesConstraintParser(errors);
    }

    public RuleStatement parse(Adl14Parser.AssertionContext assertionContext) {
        Assertion assertion = new Assertion();
        if (assertionContext.booleanAssertion() != null) {
            Adl14Parser.BooleanAssertionContext context = assertionContext.booleanAssertion();
            assertion.setStringExpression(context.getText());
            if (context.identifier() != null) {
                assertion.setTag(context.identifier().getText());
            }
            assertion.setExpression(this.parseExpression(context.expression()));
            return assertion;
        }
        if (assertionContext.variableDeclaration() != null) {
            VariableDeclaration declaration = this.parseVariableDeclaration(assertionContext.variableDeclaration());
            return declaration;
        }
        return assertion;
    }

    private VariableDeclaration parseVariableDeclaration(Adl14Parser.VariableDeclarationContext context) {
        ExpressionVariable result = new ExpressionVariable();
        this.setVariableNameAndType(context, result);
        result.setExpression(this.parseExpression(context.expression()));
        return result;
    }

    private void setVariableNameAndType(Adl14Parser.VariableDeclarationContext context, ExpressionVariable result) {
        Matcher matcher = VARIABLE_ASSIGNMENT_PATTERN.matcher(context.VARIABLE_DECLARATION().getText());
        if (!matcher.matches()) {
            throw new IllegalStateException("variable declaration does not conform to $<name>:<type>. This should have been handled in the lexer and is likely a bug in Archie: " + context.getText());
        }
        result.setName(matcher.group("name"));
        result.setType(ExpressionType.fromString(matcher.group("type")));
    }

    private Expression parseExpression(Adl14Parser.ExpressionContext context) {
        if (context.SYM_IMPLIES() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_IMPLIES().getText()));
            expression.addOperand(this.parseExpression(context.expression()));
            expression.addOperand(this.parseForAllExpression(context.booleanForAllExpression()));
            return expression;
        }
        return this.parseForAllExpression(context.booleanForAllExpression());
    }

    private Expression parseForAllExpression(Adl14Parser.BooleanForAllExpressionContext context) {
        if (context.SYM_FOR_ALL() != null) {
            Expression pathExpression = null;
            pathExpression = context.adlRulesPath() != null ? this.parseModelReference(context.adlRulesPath()) : this.parseVariableReference(context.variableReference());
            String variableName = context.identifier().getText();
            return new ForAllStatement(variableName, pathExpression, this.parseForAllExpression(context.booleanForAllExpression()));
        }
        return this.parseOrExpression(context.booleanOrExpression());
    }

    private Expression parseOrExpression(Adl14Parser.BooleanOrExpressionContext context) {
        if (context.SYM_OR() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_OR().getText()));
            expression.addOperand(this.parseOrExpression(context.booleanOrExpression()));
            expression.addOperand(this.parseAndExpression(context.booleanAndExpression()));
            return expression;
        }
        return this.parseAndExpression(context.booleanAndExpression());
    }

    private Expression parseAndExpression(Adl14Parser.BooleanAndExpressionContext context) {
        if (context.SYM_AND() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_AND().getText()));
            expression.addOperand(this.parseAndExpression(context.booleanAndExpression()));
            expression.addOperand(this.parseXorExpression(context.booleanXorExpression()));
            return expression;
        }
        return this.parseXorExpression(context.booleanXorExpression());
    }

    private Expression parseXorExpression(Adl14Parser.BooleanXorExpressionContext context) {
        if (context.SYM_XOR() != null) {
            BinaryOperator expression = new BinaryOperator();
            expression.setType(ExpressionType.BOOLEAN);
            expression.setOperator(OperatorKind.parse(context.SYM_XOR().getText()));
            expression.addOperand(this.parseBooleanNotExpression(context.booleanNotExpression()));
            expression.addOperand(this.parseXorExpression(context.booleanXorExpression()));
            return expression;
        }
        return this.parseBooleanNotExpression(context.booleanNotExpression());
    }

    private Expression parseBooleanNotExpression(Adl14Parser.BooleanNotExpressionContext context) {
        if (context.SYM_NOT() != null) {
            return new UnaryOperator(ExpressionType.BOOLEAN, OperatorKind.not, this.parseBooleanNotExpression(context.booleanNotExpression()));
        }
        return this.parseBooleanConstraintExpression(context.booleanConstraintExpression());
    }

    private Expression parseBooleanConstraintExpression(Adl14Parser.BooleanConstraintExpressionContext context) {
        if (context.booleanConstraint() != null) {
            return this.parseBooleanConstraint(context.booleanConstraint());
        }
        return this.parseEqualityExpression(context.equalityExpression());
    }

    private Expression parseBooleanLiteral(Adl14Parser.BooleanLiteralContext context) {
        return new Constant<Boolean>(ExpressionType.BOOLEAN, context.SYM_TRUE() != null);
    }

    private ModelReference parseModelReference(Adl14Parser.AdlRulesPathContext context) {
        String variableReference = null;
        String path = context.ADL_PATH().getText();
        if (context.SYM_VARIABLE_START() != null) {
            variableReference = Adl14CComplexObjectParser.getFirstAttributeOfPath(path);
            path = Adl14CComplexObjectParser.getPathMinusFirstAttribute(path);
        }
        return new ModelReference(variableReference, path);
    }

    private Expression parseBooleanConstraint(Adl14Parser.BooleanConstraintContext context) {
        ModelReference modelReference = null;
        if (context.adlRulesPath() != null) {
            modelReference = this.parseModelReference(context.adlRulesPath());
        }
        CPrimitiveObject cPrimitiveObject = null;
        cPrimitiveObject = context.c_primitive_object() != null ? this.primitivesConstraintParser.parsePrimitiveObject(context.c_primitive_object()) : this.primitivesConstraintParser.parseRegex(context.CONTAINED_REGEXP());
        return new BinaryOperator(ExpressionType.BOOLEAN, OperatorKind.matches, modelReference, new Constraint<CPrimitiveObject>(cPrimitiveObject));
    }

    private Expression parseEqualityExpression(Adl14Parser.EqualityExpressionContext context) {
        if (context.equalityBinop() != null) {
            Expression left = this.parseEqualityExpression(context.equalityExpression());
            Expression right = this.parseRelOpExpression(context.relOpExpression());
            if (left.getType() != null && right.getType() != null && left.getType() != right.getType()) {
                throw new IllegalArgumentException("arithmetic relop expression with different types: " + (Object)((Object)left.getType()) + " + " + (Object)((Object)right.getType()));
            }
            return new BinaryOperator(left.getType(), OperatorKind.parse(context.equalityBinop().getText()), left, right);
        }
        return this.parseRelOpExpression(context.relOpExpression());
    }

    private Expression parseRelOpExpression(Adl14Parser.RelOpExpressionContext context) {
        if (context.relationalBinop() != null) {
            Expression left = this.parseRelOpExpression(context.relOpExpression());
            Expression right = this.parseArithmeticExpression(context.arithmeticExpression());
            if (left.getType() != null && right.getType() != null && left.getType() != right.getType()) {
                throw new IllegalArgumentException("arithmetic relop expression with different types: " + (Object)((Object)left.getType()) + " + " + (Object)((Object)right.getType()));
            }
            return new BinaryOperator(left.getType(), OperatorKind.parse(context.relationalBinop().getText()), left, right);
        }
        return this.parseArithmeticExpression(context.arithmeticExpression());
    }

    private Expression parseArithmeticExpression(Adl14Parser.ArithmeticExpressionContext context) {
        if (context.plusMinusBinop() != null) {
            Expression left = this.parseArithmeticExpression((Adl14Parser.ArithmeticExpressionContext)context.arithmeticExpression().get(0));
            Expression right = this.parseArithmeticExpression((Adl14Parser.ArithmeticExpressionContext)context.arithmeticExpression().get(1));
            return new BinaryOperator(right.getType(), OperatorKind.parse(context.plusMinusBinop().getText()), left, right);
        }
        if (context.multBinop() != null) {
            Expression left = this.parseArithmeticExpression((Adl14Parser.ArithmeticExpressionContext)context.arithmeticExpression().get(0));
            Expression right = this.parseArithmeticExpression((Adl14Parser.ArithmeticExpressionContext)context.arithmeticExpression().get(1));
            return new BinaryOperator(right.getType(), OperatorKind.parse(context.multBinop().getText()), left, right);
        }
        if (context.powBinop() != null) {
            Expression left = this.parseArithmeticExpression((Adl14Parser.ArithmeticExpressionContext)context.arithmeticExpression().get(0));
            Expression right = this.parseArithmeticExpression((Adl14Parser.ArithmeticExpressionContext)context.arithmeticExpression().get(1));
            return new BinaryOperator(right.getType(), OperatorKind.parse(context.powBinop().getText()), left, right);
        }
        return this.parseExpressionLeaf(context.expressionLeaf());
    }

    private Expression parseExpressionLeaf(Adl14Parser.ExpressionLeafContext context) {
        if (context.integer_value() != null) {
            return new Constant<Long>(ExpressionType.INTEGER, Long.parseLong(context.integer_value().getText()));
        }
        if (context.real_value() != null) {
            return new Constant<Double>(ExpressionType.REAL, Double.parseDouble(context.real_value().getText()));
        }
        if (context.string_value() != null) {
            return new Constant<String>(ExpressionType.STRING, Odin14ValueParser.parseOdinStringValue(context.string_value()));
        }
        if (context.adlRulesPath() != null) {
            ModelReference reference = this.parseModelReference(context.adlRulesPath());
            if (context.SYM_EXISTS() != null) {
                return new UnaryOperator(ExpressionType.BOOLEAN, OperatorKind.exists, reference);
            }
            return reference;
        }
        if (context.expression() != null) {
            Expression expression = this.parseExpression(context.expression());
            expression.setPrecedenceOverridden(true);
            return expression;
        }
        if (context.expressionLeaf() != null) {
            return new UnaryOperator(ExpressionType.REAL, OperatorKind.minus, this.parseExpressionLeaf(context.expressionLeaf()));
        }
        if (context.variableReference() != null) {
            return this.parseVariableReference(context.variableReference());
        }
        if (context.booleanLiteral() != null) {
            return this.parseBooleanLiteral(context.booleanLiteral());
        }
        if (context.variableReference() != null) {
            return this.parseVariableReference(context.variableReference());
        }
        if (context.functionName() != null) {
            return this.parseFunctionCall(context);
        }
        throw new IllegalArgumentException("cannot parse unknown arithmetic leaf type: " + context.getText());
    }

    private Expression parseFunctionCall(Adl14Parser.ExpressionLeafContext context) {
        String functionName = context.functionName().getText();
        List<Expression> arguments = this.parseArgumentList(context.argumentList());
        return new Function(functionName, arguments);
    }

    private List<Expression> parseArgumentList(Adl14Parser.ArgumentListContext argumentListContext) {
        ArrayList<Expression> expressions;
        if (argumentListContext == null) {
            expressions = new ArrayList<Expression>();
        } else {
            expressions = new ArrayList(argumentListContext.expression().size());
            for (Adl14Parser.ExpressionContext expressionContext : argumentListContext.expression()) {
                expressions.add(this.parseExpression(expressionContext));
            }
        }
        return expressions;
    }

    private Expression parseVariableReference(Adl14Parser.VariableReferenceContext context) {
        VariableReference reference = new VariableReference();
        VariableDeclaration declaration = new VariableDeclaration();
        declaration.setName(context.identifier().getText());
        reference.setDeclaration(declaration);
        return reference;
    }
}

