/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.treewalkers;

import com.nedap.archie.adl14.ADL14ConversionConfiguration;
import com.nedap.archie.adl14.treewalkers.Adl14CComplexObjectParser;
import com.nedap.archie.adl14.treewalkers.Adl14TerminologyParser;
import com.nedap.archie.adl14.treewalkers.Odin14ValueParser;
import com.nedap.archie.adlparser.antlr.Adl14BaseListener;
import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.LanguageSection;
import com.nedap.archie.aom.ResourceDescription;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ADL14Listener
extends Adl14BaseListener {
    private ANTLRParserErrors errors;
    private Archetype rootArchetype;
    private Archetype archetype;
    private Adl14CComplexObjectParser subTreeWalker;
    private Adl14TerminologyParser terminologyParser;
    private Odin14ValueParser odinParser;

    public ADL14Listener(ANTLRParserErrors errors, ADL14ConversionConfiguration configuration) {
        this.errors = errors;
        this.odinParser = new Odin14ValueParser(configuration);
        this.subTreeWalker = new Adl14CComplexObjectParser(errors, this.odinParser);
        this.terminologyParser = new Adl14TerminologyParser(errors, configuration, this.odinParser);
    }

    public void enterArchetype(Adl14Parser.ArchetypeContext ctx) {
        this.archetype = this.rootArchetype = new AuthoredArchetype();
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    public void exitArchetype(Adl14Parser.ArchetypeContext ctx) {
        this.rootArchetype.setDifferential(true);
    }

    private void parseArchetypeHRID(TerminalNode hrId) {
        if (hrId != null) {
            ArchetypeHRID archetypeID = new ArchetypeHRID(hrId.getText());
            this.archetype.setArchetypeId(archetypeID);
        }
    }

    public void enterMeta_data_item(Adl14Parser.Meta_data_itemContext ctx) {
        if (this.archetype instanceof AuthoredArchetype) {
            AuthoredArchetype authoredArchetype = (AuthoredArchetype)this.archetype;
            if (ctx.meta_data_tag_adl_version() != null) {
                if (ctx.VERSION_ID() != null) {
                    authoredArchetype.setAdlVersion(ctx.VERSION_ID().getText());
                } else if (ctx.REAL() != null) {
                    authoredArchetype.setAdlVersion(ctx.REAL().getText());
                }
            }
            if (ctx.meta_data_tag_build_uid() != null) {
                authoredArchetype.setBuildUid(ctx.guid_or_oid().getText());
            }
            if (ctx.meta_data_tag_rm_release() != null) {
                authoredArchetype.setRmRelease(ctx.VERSION_ID().getText());
            }
            if (ctx.meta_data_tag_is_controlled() != null) {
                authoredArchetype.setControlled(true);
            }
            if (ctx.meta_data_tag_is_generated() != null) {
                authoredArchetype.setGenerated(true);
            }
            if (ctx.meta_data_tag_uid() != null) {
                authoredArchetype.setUid(ctx.guid_or_oid().getText());
            } else if (ctx.identifier() != null) {
                authoredArchetype.addOtherMetadata(ctx.identifier().getText(), ctx.meta_data_value() == null ? null : ctx.meta_data_value().getText());
            }
        }
    }

    public void enterDefinition_section(Adl14Parser.Definition_sectionContext ctx) {
        CComplexObject definition = this.subTreeWalker.parseComplexObject(ctx.c_complex_object());
        this.archetype.setDefinition(definition);
    }

    public void enterLanguage_section(Adl14Parser.Language_sectionContext ctx) {
        this.archetype.setAuthoredResourceContent(this.odinParser.convert(ctx.odin_text().getText(), LanguageSection.class));
    }

    public void enterTerminology_section(Adl14Parser.Terminology_sectionContext ctx) {
        this.archetype.setTerminology(this.terminologyParser.parseTerminology(ctx));
    }

    public void enterDescription_section(Adl14Parser.Description_sectionContext ctx) {
        this.archetype.setDescription(this.odinParser.convert(ctx.odin_text().getText(), ResourceDescription.class));
    }

    public void enterSpecialization_section(Adl14Parser.Specialization_sectionContext ctx) {
        if (ctx != null && ctx.archetype_ref() != null) {
            this.archetype.setParentArchetypeId(ctx.archetype_ref().getText());
        }
    }

    public void enterRules_section(Adl14Parser.Rules_sectionContext ctx) {
        this.archetype.setRules(this.subTreeWalker.parseRules(ctx));
    }

    public Archetype getArchetype() {
        return this.rootArchetype;
    }

    public ANTLRParserErrors getErrors() {
        return this.errors;
    }
}

