/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.adl14.IdCodeGenerator;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.utils.AOMUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public class OutsideRangeIdCodeGenerator
implements IdCodeGenerator {
    private final Archetype archetype;
    private final Set<String> allUsedCodes;
    private Set<String> generatedCodes = new LinkedHashSet<String>();
    private int counter = 9000;

    public OutsideRangeIdCodeGenerator(Archetype archetype) {
        this.archetype = archetype;
        this.allUsedCodes = archetype.getAllUsedCodes();
        this.counter = Math.max(this.counter, AOMUtils.getMaximumIdCode(archetype.specializationDepth(), this.allUsedCodes));
    }

    @Override
    public String generateNextIdCode() {
        return this.generateNextCode("id");
    }

    @Override
    public String generateNextValueCode() {
        return this.generateNextCode("at");
    }

    @Override
    public String generateNextValueSetCode() {
        return this.generateNextCode("ac");
    }

    @Override
    public String generateNextSpecializedIdCode(String nodeId) {
        return this.archetype.generateNextSpecializedIdCode(nodeId);
    }

    private String generateNextCode(String prefix) {
        int specializationDepth = this.archetype.specializationDepth();
        String result = prefix + this.generateSpecializationDepthCodePrefix(specializationDepth) + this.counter;
        while (this.allUsedCodes.contains(result)) {
            ++this.counter;
            result = prefix + this.generateSpecializationDepthCodePrefix(specializationDepth) + this.counter;
        }
        ++this.counter;
        this.generatedCodes.add(result);
        return result;
    }

    private String generateSpecializationDepthCodePrefix(int specializationDepth) {
        String prefix = "";
        for (int i = 0; i < specializationDepth; ++i) {
            prefix = prefix + "0.";
        }
        return prefix;
    }
}

