/*
 * Decompiled with CFR 0.152.
 */
package com.github.ooxi.phparser;

import com.github.ooxi.phparser.SerializedPhpParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedPhpParser {
    private final String input;
    private final int inputLength;
    private int index;
    private boolean assumeUTF8 = true;
    private final ArrayList<Object> refArray = new ArrayList();
    private Pattern acceptedAttributeNameRegex = null;
    public static final Object NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };

    public SerializedPhpParser(String input) {
        this.input = input;
        this.inputLength = input.length();
    }

    public SerializedPhpParser(String input, boolean assumeUTF8) {
        this.input = input;
        this.inputLength = input.length();
        this.assumeUTF8 = assumeUTF8;
    }

    public Object parse() throws SerializedPhpParserException {
        Object result = this.parseInternal(false);
        this.cleanup();
        return result;
    }

    private void cleanup() {
        this.refArray.clear();
    }

    private Object parseInternal(boolean isKey) throws SerializedPhpParserException {
        this.checkUnexpectedLength(this.index + 2);
        char type = this.input.charAt(this.index);
        switch (type) {
            case 'i': {
                this.index += 2;
                return this.parseInt(isKey);
            }
            case 'd': {
                this.index += 2;
                return this.parseFloat(isKey);
            }
            case 'b': {
                this.index += 2;
                return this.parseBoolean();
            }
            case 's': {
                this.index += 2;
                return this.parseString(isKey);
            }
            case 'a': {
                this.index += 2;
                return this.parseArray();
            }
            case 'O': {
                this.index += 2;
                return this.parseObject();
            }
            case 'N': {
                this.index += 2;
                return NULL;
            }
            case 'R': {
                this.index += 2;
                return this.parseReference();
            }
        }
        throw new SerializedPhpParserException("Encountered unknown type [" + type + "]", this.index, 9);
    }

    private Object parseReference() throws SerializedPhpParserException {
        int delimiter = this.input.indexOf(59, this.index);
        if (delimiter == -1) {
            throw new SerializedPhpParserException("Unexpected end of serialized Reference!", this.index, 5);
        }
        this.checkUnexpectedLength(delimiter + 1);
        Integer refIndex = Integer.valueOf(this.input.substring(this.index, delimiter)) - 1;
        this.index = delimiter + 1;
        if (refIndex + 1 > this.refArray.size()) {
            throw new SerializedPhpParserException("Out of range reference index: " + (refIndex + 1) + " !", this.index, 3);
        }
        Object value = this.refArray.get(refIndex);
        this.refArray.add(value);
        return value;
    }

    private Object parseObject() throws SerializedPhpParserException {
        PhpObject phpObject = new PhpObject();
        this.refArray.add(phpObject);
        int strLen = this.readLength();
        this.checkUnexpectedLength(strLen);
        phpObject.name = this.input.substring(this.index, this.index + strLen);
        this.index = this.index + strLen + 2;
        int attrLen = this.readLength();
        for (int i = 0; i < attrLen; ++i) {
            Object key = this.parseInternal(true);
            Object value = this.parseInternal(false);
            if (!this.isAcceptedAttribute(key)) continue;
            phpObject.attributes.put(key, value);
        }
        ++this.index;
        return phpObject;
    }

    private Map<Object, Object> parseArray() throws SerializedPhpParserException {
        int arrayLen = this.readLength();
        this.checkUnexpectedLength(arrayLen);
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        this.refArray.add(result);
        for (int i = 0; i < arrayLen; ++i) {
            Object key = this.parseInternal(true);
            Object value = this.parseInternal(false);
            if (!this.isAcceptedAttribute(key)) continue;
            result.put(key, value);
        }
        char endChar = this.input.charAt(this.index);
        if (endChar != '}') {
            throw new SerializedPhpParserException("Unexpected end of serialized Array, missing }!", this.index, 4);
        }
        ++this.index;
        return result;
    }

    private boolean isAcceptedAttribute(Object key) {
        if (this.acceptedAttributeNameRegex == null) {
            return true;
        }
        if (!(key instanceof String)) {
            return true;
        }
        return this.acceptedAttributeNameRegex.matcher((String)key).matches();
    }

    private int readLength() throws SerializedPhpParserException {
        int delimiter = this.input.indexOf(58, this.index);
        if (delimiter == -1) {
            throw new SerializedPhpParserException("Missing delimiter after string, array or object length field!", this.index, 5);
        }
        this.checkUnexpectedLength(delimiter + 2);
        int arrayLen = Integer.valueOf(this.input.substring(this.index, delimiter));
        this.index = delimiter + 2;
        return arrayLen;
    }

    private String parseString(boolean isKey) throws SerializedPhpParserException {
        int strLen = this.readLength();
        this.checkUnexpectedLength(strLen);
        int utfStrLen = 0;
        int byteCount = 0;
        int nextCharIndex = 0;
        while (byteCount != strLen) {
            if ((nextCharIndex = this.index + utfStrLen++) >= this.inputLength) {
                throw new SerializedPhpParserException("Unexpected end of String (" + strLen + ") at position " + (nextCharIndex - this.index) + ", absolut position in Input String: " + nextCharIndex + ". The string: " + this.input.substring(this.index, nextCharIndex), nextCharIndex, 1);
            }
            char ch = this.input.charAt(nextCharIndex);
            if (this.assumeUTF8) {
                if (ch >= '\u0000' && ch <= '\u007f') {
                    ++byteCount;
                    continue;
                }
                if (ch > '\u07ff') {
                    byteCount += 3;
                    continue;
                }
                byteCount += 2;
                continue;
            }
            ++byteCount;
        }
        String value = this.input.substring(this.index, this.index + utfStrLen);
        if (this.index + utfStrLen + 2 > this.inputLength || this.index + utfStrLen > this.inputLength) {
            throw new SerializedPhpParserException("Unexpected serialized string length!", this.index, 1);
        }
        String endString = this.input.substring(this.index + utfStrLen, this.index + utfStrLen + 2);
        if (!endString.equals("\";")) {
            throw new SerializedPhpParserException("Unexpected serialized string length!", this.index, 2);
        }
        this.index = this.index + utfStrLen + 2;
        if (!isKey) {
            this.refArray.add(value);
        }
        return value;
    }

    private Boolean parseBoolean() throws SerializedPhpParserException {
        int delimiter = this.input.indexOf(59, this.index);
        if (delimiter == -1) {
            throw new SerializedPhpParserException("Unexpected end of serialized boolean!", this.index);
        }
        this.checkUnexpectedLength(delimiter + 1);
        String value = this.input.substring(this.index, delimiter);
        if (value.equals("1")) {
            value = "true";
        } else if (value.equals("0")) {
            value = "false";
        }
        this.index = delimiter + 1;
        this.refArray.add(Boolean.valueOf(value));
        return Boolean.valueOf(value);
    }

    private Double parseFloat(boolean isKey) throws SerializedPhpParserException {
        int delimiter = this.input.indexOf(59, this.index);
        if (delimiter == -1) {
            throw new SerializedPhpParserException("Unexpected end of serialized float!", this.index, 5);
        }
        this.checkUnexpectedLength(delimiter + 1);
        String value = this.input.substring(this.index, delimiter);
        this.index = delimiter + 1;
        if (!isKey) {
            this.refArray.add(Double.valueOf(value));
        }
        return Double.valueOf(value);
    }

    private Long parseInt(boolean isKey) throws SerializedPhpParserException {
        int delimiter = this.input.indexOf(59, this.index);
        if (delimiter == -1) {
            throw new SerializedPhpParserException("Unexpected end of serialized integer!", this.index, 5);
        }
        this.checkUnexpectedLength(delimiter + 1);
        String value = this.input.substring(this.index, delimiter);
        this.index = delimiter + 1;
        if (!isKey) {
            this.refArray.add(Long.valueOf(value));
        }
        return Long.valueOf(value);
    }

    public void setAcceptedAttributeNameRegex(String acceptedAttributeNameRegex) {
        this.acceptedAttributeNameRegex = Pattern.compile(acceptedAttributeNameRegex);
    }

    private void checkUnexpectedLength(int newIndex) throws SerializedPhpParserException {
        if (this.index > this.inputLength || newIndex > this.inputLength) {
            throw new SerializedPhpParserException("Unexpected end of serialized Input!", this.index, 6);
        }
    }

    public static class PhpObject {
        public String name;
        public Map<Object, Object> attributes = new HashMap<Object, Object>();

        public String toString() {
            return "\"" + this.name + "\" : " + this.attributes.toString();
        }
    }
}

