/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.willy.ratingbar.AnimationRatingBar;
import com.willy.ratingbar.PartialView;
import com.willy.ratingbar.R;

public class RotationRatingBar
extends AnimationRatingBar {
    public RotationRatingBar(Context context) {
        super(context);
    }

    public RotationRatingBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public RotationRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void emptyRatingBar() {
        this.mDelay = 0;
        this.mStopFillingFlag = true;
        for (final PartialView partialView : this.mPartialViews) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    partialView.setEmpty();
                }
            }, (long)(this.mDelay += 5));
        }
    }

    @Override
    protected void fillRatingBar(final float rating) {
        this.mDelay = 0;
        for (final PartialView partialView : this.mPartialViews) {
            double maxIntOfRating;
            final int ratingViewId = (Integer)partialView.getTag();
            if ((double)ratingViewId > (maxIntOfRating = Math.ceil(rating))) {
                partialView.setEmpty();
                continue;
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (RotationRatingBar.this.mStopFillingFlag) {
                        return;
                    }
                    if ((double)ratingViewId == maxIntOfRating) {
                        partialView.setPartialFilled(rating);
                    } else {
                        partialView.setFilled();
                    }
                    if ((float)ratingViewId == rating) {
                        Animation rotation = AnimationUtils.loadAnimation((Context)RotationRatingBar.this.getContext(), (int)R.anim.rotation);
                        partialView.startAnimation(rotation);
                    }
                }
            }, (long)(this.mDelay += 15));
        }
    }
}

