/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.ScrollingView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.github.nukc.stateview.AnimatorProvider;
import com.github.nukc.stateview.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StateView
extends View {
    public static final int EMPTY = 0;
    public static final int RETRY = 1;
    public static final int LOADING = 2;
    private int mEmptyResource;
    private int mRetryResource;
    private int mLoadingResource;
    private View mEmptyView;
    private View mRetryView;
    private View mLoadingView;
    private LayoutInflater mInflater;
    private OnRetryClickListener mRetryClickListener;
    private OnInflateListener mInflateListener;
    private RelativeLayout.LayoutParams mLayoutParams;
    private AnimatorProvider mProvider = null;

    public static StateView inject(@NonNull Activity activity) {
        return StateView.inject(activity, false);
    }

    public static StateView inject(@NonNull Activity activity, boolean hasActionBar) {
        ViewGroup rootView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        return StateView.inject(rootView, hasActionBar);
    }

    public static StateView inject(@NonNull ViewGroup parent) {
        return StateView.inject(parent, false);
    }

    public static StateView inject(@NonNull ViewGroup parent, boolean hasActionBar) {
        int screenHeight = 0;
        if (parent instanceof LinearLayout || parent instanceof ScrollView || parent instanceof AdapterView || parent instanceof ScrollingView && parent instanceof NestedScrollingChild || parent instanceof NestedScrollingParent && parent instanceof NestedScrollingChild) {
            ViewParent viewParent = parent.getParent();
            if (viewParent == null) {
                FrameLayout wrapper = new FrameLayout(parent.getContext());
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
                wrapper.setLayoutParams(layoutParams);
                if (parent instanceof LinearLayout) {
                    LinearLayout wrapLayout = new LinearLayout(parent.getContext());
                    wrapLayout.setLayoutParams(parent.getLayoutParams());
                    wrapLayout.setOrientation(((LinearLayout)parent).getOrientation());
                    int childCount = parent.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        View childView = parent.getChildAt(0);
                        parent.removeView(childView);
                        wrapLayout.addView(childView);
                    }
                    wrapper.addView((View)wrapLayout);
                } else if (parent instanceof ScrollView || parent instanceof ScrollingView) {
                    if (parent.getChildCount() != 1) {
                        throw new IllegalStateException("the ScrollView does not have one direct child");
                    }
                    View directView = parent.getChildAt(0);
                    parent.removeView(directView);
                    wrapper.addView(directView);
                    WindowManager wm = (WindowManager)parent.getContext().getSystemService("window");
                    DisplayMetrics metrics = new DisplayMetrics();
                    wm.getDefaultDisplay().getMetrics(metrics);
                    screenHeight = metrics.heightPixels;
                } else if (parent instanceof NestedScrollingParent && parent instanceof NestedScrollingChild) {
                    if (parent.getChildCount() == 2) {
                        View targetView = parent.getChildAt(1);
                        parent.removeView(targetView);
                        wrapper.addView(targetView);
                    } else if (parent.getChildCount() > 2) {
                        throw new IllegalStateException("the view is not refresh layout? view = " + parent.toString());
                    }
                } else {
                    throw new IllegalStateException("the view does not have parent, view = " + parent.toString());
                }
                parent.addView((View)wrapper);
                parent = wrapper;
            } else {
                FrameLayout root = new FrameLayout(parent.getContext());
                root.setLayoutParams(parent.getLayoutParams());
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
                parent.setLayoutParams(layoutParams);
                if (viewParent instanceof ViewGroup) {
                    ViewGroup rootGroup = (ViewGroup)viewParent;
                    rootGroup.removeView((View)parent);
                    rootGroup.addView((View)root);
                }
                root.addView((View)parent);
                parent = root;
            }
        }
        StateView stateView = new StateView(parent.getContext());
        if (screenHeight > 0) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, hasActionBar ? screenHeight - stateView.getActionBarHeight() : screenHeight);
            parent.addView((View)stateView, params);
        } else {
            parent.addView((View)stateView);
        }
        if (hasActionBar) {
            stateView.setTopMargin();
        }
        stateView.getLayoutParams().width = -1;
        stateView.getLayoutParams().height = -1;
        return stateView;
    }

    public static StateView inject(@NonNull View view) {
        return StateView.inject(view, false);
    }

    public static StateView inject(@NonNull View view, boolean hasActionBar) {
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            return StateView.inject(parent, hasActionBar);
        }
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            return StateView.inject((ViewGroup)parent, hasActionBar);
        }
        throw new ClassCastException("view or view.getParent() must be ViewGroup");
    }

    public StateView(Context context) {
        this(context, null);
    }

    public StateView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StateView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StateView);
        this.mEmptyResource = a.getResourceId(R.styleable.StateView_emptyResource, 0);
        this.mRetryResource = a.getResourceId(R.styleable.StateView_retryResource, 0);
        this.mLoadingResource = a.getResourceId(R.styleable.StateView_loadingResource, 0);
        a.recycle();
        if (this.mEmptyResource == 0) {
            this.mEmptyResource = R.layout.base_empty;
        }
        if (this.mRetryResource == 0) {
            this.mRetryResource = R.layout.base_retry;
        }
        if (this.mLoadingResource == 0) {
            this.mLoadingResource = R.layout.base_loading;
        }
        this.mLayoutParams = attrs == null ? new RelativeLayout.LayoutParams(-1, -1) : new RelativeLayout.LayoutParams(context, attrs);
        this.setVisibility(8);
        this.setWillNotDraw(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(Canvas canvas) {
    }

    protected void dispatchDraw(Canvas canvas) {
    }

    public void setVisibility(int visibility) {
        this.setVisibility(this.mEmptyView, visibility);
        this.setVisibility(this.mRetryView, visibility);
        this.setVisibility(this.mLoadingView, visibility);
    }

    private void setVisibility(View view, int visibility) {
        if (view != null && visibility != view.getVisibility()) {
            if (this.mProvider != null) {
                this.startAnimation(view);
            } else {
                view.setVisibility(visibility);
            }
        }
    }

    public void showContent() {
        this.setVisibility(8);
    }

    public View showEmpty() {
        if (this.mEmptyView == null) {
            this.mEmptyView = this.inflate(this.mEmptyResource, 0);
        }
        this.showView(this.mEmptyView);
        return this.mEmptyView;
    }

    public View showRetry() {
        if (this.mRetryView == null) {
            this.mRetryView = this.inflate(this.mRetryResource, 1);
            this.mRetryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (StateView.this.mRetryClickListener != null) {
                        StateView.this.showLoading();
                        StateView.this.mRetryView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                StateView.this.mRetryClickListener.onRetryClick();
                            }
                        }, 400L);
                    }
                }
            });
        }
        this.showView(this.mRetryView);
        return this.mRetryView;
    }

    public View showLoading() {
        if (this.mLoadingView == null) {
            this.mLoadingView = this.inflate(this.mLoadingResource, 2);
        }
        this.showView(this.mLoadingView);
        return this.mLoadingView;
    }

    private void showView(View view) {
        this.setVisibility(view, 0);
        this.hideViews(view);
    }

    private void hideViews(View showView) {
        if (this.mEmptyView == showView) {
            this.setVisibility(this.mLoadingView, 8);
            this.setVisibility(this.mRetryView, 8);
        } else if (this.mLoadingView == showView) {
            this.setVisibility(this.mEmptyView, 8);
            this.setVisibility(this.mRetryView, 8);
        } else {
            this.setVisibility(this.mEmptyView, 8);
            this.setVisibility(this.mLoadingView, 8);
        }
    }

    private void startAnimation(final View view) {
        Animator animator;
        final boolean toShow = view.getVisibility() == 8;
        Animator animator2 = animator = toShow ? this.mProvider.showAnimation(view) : this.mProvider.hideAnimation(view);
        if (animator == null) {
            view.setVisibility(toShow ? 0 : 8);
            return;
        }
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (!toShow) {
                    view.setVisibility(8);
                }
            }

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (toShow) {
                    view.setVisibility(0);
                }
            }
        });
        animator.start();
    }

    public void setAnimatorProvider(AnimatorProvider provider) {
        this.mProvider = provider;
        this.reset(this.mEmptyView);
        this.reset(this.mLoadingView);
        this.reset(this.mRetryView);
    }

    private void reset(View view) {
        if (view != null) {
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
            view.setAlpha(1.0f);
            view.setRotation(0.0f);
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
        }
    }

    private View inflate(@LayoutRes int layoutResource, int viewType) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (layoutResource != 0) {
                ViewGroup parent = (ViewGroup)viewParent;
                LayoutInflater factory = this.mInflater != null ? this.mInflater : LayoutInflater.from((Context)this.getContext());
                View view = factory.inflate(layoutResource, parent, false);
                int index = parent.indexOfChild((View)this);
                view.setClickable(true);
                view.setVisibility(8);
                ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                if (layoutParams != null) {
                    if (parent instanceof RelativeLayout) {
                        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)layoutParams;
                        this.mLayoutParams.setMargins(lp.leftMargin, lp.topMargin, lp.rightMargin, lp.bottomMargin);
                        parent.addView(view, index, (ViewGroup.LayoutParams)this.mLayoutParams);
                    } else {
                        parent.addView(view, index, layoutParams);
                    }
                } else {
                    parent.addView(view, index);
                }
                if (this.mLoadingView != null && this.mRetryView != null && this.mEmptyView != null) {
                    parent.removeViewInLayout((View)this);
                }
                if (this.mInflateListener != null) {
                    this.mInflateListener.onInflate(viewType, view);
                }
                return view;
            }
            throw new IllegalArgumentException("StateView must have a valid layoutResource");
        }
        throw new IllegalStateException("StateView must have a non-null ViewGroup viewParent");
    }

    public void setTopMargin() {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        layoutParams.topMargin = this.getActionBarHeight();
    }

    public int getActionBarHeight() {
        int height = 0;
        TypedValue tv = new TypedValue();
        if (this.getContext().getTheme().resolveAttribute(R.attr.actionBarSize, tv, true)) {
            height = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
        return height;
    }

    public void setEmptyResource(@LayoutRes int emptyResource) {
        this.mEmptyResource = emptyResource;
    }

    public void setRetryResource(@LayoutRes int retryResource) {
        this.mRetryResource = retryResource;
    }

    public void setLoadingResource(@LayoutRes int loadingResource) {
        this.mLoadingResource = loadingResource;
    }

    public LayoutInflater getInflater() {
        return this.mInflater;
    }

    public void setInflater(LayoutInflater inflater) {
        this.mInflater = inflater;
    }

    public void setOnRetryClickListener(OnRetryClickListener listener) {
        this.mRetryClickListener = listener;
    }

    public void setOnInflateListener(OnInflateListener inflateListener) {
        this.mInflateListener = inflateListener;
    }

    public static interface OnInflateListener {
        public void onInflate(int var1, View var2);
    }

    public static interface OnRetryClickListener {
        public void onRetryClick();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewType {
    }
}

