/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.recycleradapter;

import androidx.annotation.MainThread;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0007J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\u0012\u001a\u00020\nH\u0007J\b\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0007J\u0016\u0010\u0017\u001a\u00020\n2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0007J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/github/nukc/recycleradapter/BaseAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "items", "", "", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "add", "", "item", "position", "", "addAll", "positionStart", "", "change", "clear", "getItemCount", "move", "fromPosition", "toPosition", "refresh", "remove", "recycleradapter_release"})
public abstract class BaseAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final List<Object> items;

    public int getItemCount() {
        return this.items.size();
    }

    @MainThread
    public final void refresh(@NotNull List<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.items.clear();
        this.items.addAll((Collection<Object>)items);
        this.notifyDataSetChanged();
    }

    @MainThread
    public final void addAll(@NotNull List<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.addAll(this.getItemCount(), items);
    }

    @MainThread
    public final void addAll(int positionStart, @NotNull List<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.items.addAll(positionStart, (Collection<Object>)items);
        this.notifyItemRangeInserted(positionStart, items.size());
    }

    @MainThread
    public final void add(int position, @NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.items.add(position, item);
        this.notifyItemInserted(position);
    }

    @MainThread
    public final void add(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.add(this.items.size(), item);
    }

    @MainThread
    public final void change(int position, @NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.items.set(position, item);
        this.notifyItemChanged(position);
    }

    @MainThread
    public final void remove(int position) {
        this.items.remove(position);
        this.notifyItemRemoved(position);
    }

    @MainThread
    public final void move(int fromPosition, int toPosition) {
        Object item = this.items.remove(fromPosition);
        this.items.add(toPosition, item);
        this.notifyItemMoved(fromPosition, toPosition);
    }

    @MainThread
    public final void clear() {
        this.items.clear();
        this.notifyDataSetChanged();
    }

    @NotNull
    public final List<Object> getItems() {
        return this.items;
    }

    public BaseAdapter(@NotNull List<Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.items = items;
    }
}

