/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.recycleradapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.nukc.recycleradapter.R;

public class RecyclerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = RecyclerAdapter.class.getSimpleName();
    private static final byte TYPE_FOOTER = -2;
    private RecyclerView.Adapter mAdapter;
    private View mFooterView;
    private int mFooterResId = -1;
    private RecyclerView mRecyclerView;
    private OnLoadMoreListener mOnLoadMoreListener;
    private boolean mLoadMoreEnabled = true;
    private boolean mIsLoading = false;
    private RecyclerView.OnScrollListener mOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (!ViewCompat.canScrollVertically((View)recyclerView, (int)-1) || !RecyclerAdapter.this.mLoadMoreEnabled || RecyclerAdapter.this.mIsLoading) {
                Log.d((String)TAG, (String)"recyclerView can not scroll!");
                return;
            }
            if (newState == 0 && RecyclerAdapter.this.mOnLoadMoreListener != null) {
                boolean isBottom;
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager instanceof LinearLayoutManager) {
                    isBottom = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition() >= layoutManager.getItemCount() - 1;
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    StaggeredGridLayoutManager sgLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                    int[] into = new int[sgLayoutManager.getSpanCount()];
                    sgLayoutManager.findLastVisibleItemPositions(into);
                    isBottom = RecyclerAdapter.last(into) >= layoutManager.getItemCount() - 1;
                } else {
                    boolean bl = isBottom = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition() >= layoutManager.getItemCount() - 1;
                }
                if (layoutManager.getItemCount() > 0 && isBottom) {
                    RecyclerAdapter.this.mIsLoading = true;
                    RecyclerAdapter.this.mOnLoadMoreListener.onLoadMore();
                }
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
        }
    };
    private RecyclerView.AdapterDataObserver mObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            RecyclerAdapter.this.notifyFooterHolderChanged();
            RecyclerAdapter.this.mIsLoading = false;
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            RecyclerAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
            RecyclerAdapter.this.mIsLoading = false;
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            RecyclerAdapter.this.notifyItemRangeChanged(positionStart, itemCount, payload);
            RecyclerAdapter.this.mIsLoading = false;
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            RecyclerAdapter.this.notifyFooterHolderChanged();
            RecyclerAdapter.this.mIsLoading = false;
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RecyclerAdapter.this.notifyDataSetChanged();
            RecyclerAdapter.this.mIsLoading = false;
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            RecyclerAdapter.this.notifyItemMoved(fromPosition, toPosition);
            RecyclerAdapter.this.mIsLoading = false;
        }
    };

    public RecyclerAdapter(@NonNull RecyclerView.Adapter adapter) {
        this.registerAdapter(adapter);
    }

    public RecyclerAdapter(@NonNull RecyclerView.Adapter adapter, View footerView) {
        this.registerAdapter(adapter);
        this.mFooterView = footerView;
    }

    public RecyclerAdapter(@NonNull RecyclerView.Adapter adapter, @LayoutRes int resId) {
        this.registerAdapter(adapter);
        this.mFooterResId = resId;
    }

    private void registerAdapter(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter can not be null!");
        }
        this.mAdapter = adapter;
        this.mAdapter.registerAdapterDataObserver(this.mObserver);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == -2) {
            if (this.mFooterResId != -1) {
                this.mFooterView = LayoutInflater.from((Context)parent.getContext()).inflate(this.mFooterResId, parent, false);
            }
            if (this.mFooterView != null) {
                return new FooterHolder(this.mFooterView);
            }
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.base_footer, parent, false);
            return new FooterHolder(view);
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof FooterHolder) {
            if (!this.canScroll()) {
                holder.itemView.setVisibility(8);
            }
        } else {
            this.mAdapter.onBindViewHolder(holder, position);
        }
    }

    public int getItemCount() {
        int count = this.mAdapter.getItemCount();
        return count == 0 ? 0 : (this.mLoadMoreEnabled ? count + 1 : count);
    }

    public int getItemViewType(int position) {
        if (position == this.mAdapter.getItemCount() && this.mLoadMoreEnabled) {
            return -2;
        }
        return super.getItemViewType(position);
    }

    public boolean canScroll() {
        return ViewCompat.canScrollVertically((View)this.mRecyclerView, (int)-1);
    }

    public void setLoadMoreEnabled(boolean enabled) {
        this.mLoadMoreEnabled = enabled;
    }

    public boolean getLoadMoreEnabled() {
        return this.mLoadMoreEnabled;
    }

    public void setFooterView(View footerView) {
        this.mFooterView = footerView;
    }

    public void setFooterView(@LayoutRes int resId) {
        this.mFooterResId = resId;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        recyclerView.addOnScrollListener(this.mOnScrollListener);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            final GridLayoutManager.SpanSizeLookup originalSizeLookup = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (RecyclerAdapter.this.getItemViewType(position) == -2) {
                        return gridLayoutManager.getSpanCount();
                    }
                    if (originalSizeLookup != null) {
                        return originalSizeLookup.getSpanSize(position);
                    }
                    return 1;
                }
            });
        }
    }

    private static int last(int[] lastPositions) {
        int last = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= last) continue;
            last = value;
        }
        return last;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        recyclerView.removeOnScrollListener(this.mOnScrollListener);
        this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
        this.mRecyclerView = null;
    }

    public void setLoadMoreListener(OnLoadMoreListener listener) {
        this.mOnLoadMoreListener = listener;
    }

    private void notifyFooterHolderChanged() {
        int itemCount = this.mAdapter.getItemCount();
        if (this.mLoadMoreEnabled) {
            this.notifyItemChanged(itemCount);
        } else {
            this.notifyItemChanged(itemCount - 1);
        }
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore();
    }

    static class FooterHolder
    extends RecyclerView.ViewHolder {
        public FooterHolder(View itemView) {
            super(itemView);
            ViewGroup.LayoutParams layoutParams = itemView.getLayoutParams();
            if (layoutParams instanceof StaggeredGridLayoutManager.LayoutParams) {
                ((StaggeredGridLayoutManager.LayoutParams)layoutParams).setFullSpan(true);
            }
        }
    }
}

