/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.recycleradapter;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.github.nukc.recycleradapter.BaseAdapter;
import com.github.nukc.recycleradapter.HolderHelper;
import com.github.nukc.recycleradapter.ItemProvide;
import com.github.nukc.recycleradapter.ItemWrapper;
import com.github.nukc.recycleradapter.RecyclerHolder;
import java.util.List;

public abstract class RecyclerAdapter<T>
extends BaseAdapter<T>
implements ItemProvide {
    private SparseArray<Class<?>> mHolderClasses = new SparseArray(0);
    private Object mListener;

    public RecyclerAdapter() {
    }

    public RecyclerAdapter(List<T> dataList) {
        super(dataList);
    }

    public RecyclerAdapter(Object listener) {
        this.mListener = listener;
    }

    public RecyclerAdapter(List<T> dataList, Object listener) {
        super(dataList);
        this.mListener = listener;
    }

    public RecyclerHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Class holderClass = (Class)this.mHolderClasses.get(viewType);
        View view = this.inflate(parent, viewType);
        return HolderHelper.newInstance(holderClass, view, this.mListener);
    }

    public void onBindViewHolder(RecyclerHolder holder, int position) {
        holder.onBindView(this.getItem(position));
    }

    public int getItemViewType(int position) {
        ItemWrapper itemWrapper = this.getItemHolder(position);
        if (itemWrapper == null) {
            throw new NullPointerException("ItemWrapper is null, position = " + position);
        }
        int viewType = itemWrapper.getLayoutResId();
        Class<?> holderClass = itemWrapper.getHolderClass();
        this.addHolderClass(viewType, holderClass);
        return viewType;
    }

    private void addHolderClass(int viewType, Class<?> holderClass) {
        if (this.mHolderClasses.get(viewType) == null) {
            this.mHolderClasses.put(viewType, holderClass);
        }
    }

    public void setItemListener(Object listener) {
        this.mListener = listener;
    }
}

